/*
 * Decompiled with CFR 0.152.
 */
package net.middlemind.MmgGameApiJava.MmgBase;

import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import net.middlemind.MmgGameApiJava.MmgBase.MmgBmp;
import net.middlemind.MmgGameApiJava.MmgBase.MmgObj;
import net.middlemind.MmgGameApiJava.MmgBase.MmgPen;
import net.middlemind.MmgGameApiJava.MmgBase.MmgVector2;

public class Mmg9Slice
extends MmgObj {
    private int offset;
    private MmgBmp src;
    private MmgBmp dest;
    public static final GraphicsConfiguration GRAPHICS_CONFIG = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();

    public Mmg9Slice(int Offset, MmgBmp Src, int w, int h) {
        this.SetOffset(Offset);
        this.SetSrc(Src);
        this.SetWidth(w);
        this.SetHeight(h);
        this.SetPosition(null);
        this.SetIsVisible(true);
        this.DrawDest();
    }

    public Mmg9Slice(int Offset, MmgBmp Src, int w, int h, MmgVector2 Pos) {
        this.SetOffset(Offset);
        this.SetSrc(Src);
        this.SetWidth(w);
        this.SetHeight(h);
        this.SetPosition(Pos);
        this.SetIsVisible(true);
        this.DrawDest();
    }

    public Mmg9Slice(Mmg9Slice m) {
        this.SetOffset(m.GetOffset());
        this.SetSrc(m.GetSrc());
        this.SetWidth(m.GetWidth());
        this.SetHeight(m.GetHeight());
        this.SetPosition(m.GetPosition());
        this.SetIsVisible(m.GetIsVisible());
        this.DrawDest();
    }

    public void SetOffset(int i) {
        this.offset = i;
    }

    public int GetOffset() {
        return this.offset;
    }

    public void SetSrc(MmgBmp b) {
        this.src = b;
    }

    public MmgBmp GetSrc() {
        return this.src;
    }

    public void SetDest(MmgBmp b) {
        this.dest = b;
    }

    public MmgBmp GetDest() {
        return this.dest;
    }

    public void DrawDest() {
        boolean alpha = true;
        MmgBmp b = this.GetSrc();
        Image img = b.GetImage();
        BufferedImage bg = GRAPHICS_CONFIG.createCompatibleImage(this.GetWidth(), this.GetHeight(), alpha ? 3 : 1);
        Graphics2D g = (Graphics2D)bg.getGraphics();
        if (MmgPen.ADV_RENDER_HINTS) {
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        int fs = this.offset;
        g.drawImage(img, 0, 0, fs, fs, 0, 0, fs, fs, null);
        g.drawImage(img, fs, 0, this.GetWidth() - fs, fs, fs, 0, b.GetWidth() - fs, fs, null);
        g.drawImage(img, this.GetWidth() - fs, 0, this.GetWidth(), fs, b.GetWidth() - fs, 0, b.GetWidth(), fs, null);
        g.drawImage(img, 0, fs, fs, this.GetHeight() - fs, 0, fs, fs, b.GetHeight() - fs, null);
        g.drawImage(img, fs, fs, this.GetWidth() - fs, this.GetHeight() - fs, fs, fs, b.GetWidth() - fs, b.GetHeight() - fs, null);
        g.drawImage(img, this.GetWidth() - fs, fs, this.GetWidth(), this.GetHeight() - fs, b.GetWidth() - fs, fs, b.GetWidth(), b.GetHeight() - fs, null);
        g.drawImage(img, 0, this.GetHeight() - fs, fs, this.GetHeight(), 0, b.GetHeight() - fs, fs, b.GetHeight(), null);
        g.drawImage(img, fs, this.GetHeight() - fs, this.GetWidth() - fs, this.GetHeight(), fs, b.GetHeight() - fs, b.GetWidth() - fs, b.GetHeight(), null);
        g.drawImage(img, this.GetWidth() - fs, this.GetHeight() - fs, this.GetWidth(), this.GetHeight(), b.GetWidth() - fs, b.GetHeight() - fs, b.GetWidth(), b.GetHeight(), null);
        this.dest = new MmgBmp(bg);
    }

    @Override
    public MmgObj Clone() {
        Mmg9Slice ret = new Mmg9Slice(this);
        return ret;
    }

    @Override
    public void MmgDraw(MmgPen p) {
        if (this.GetIsVisible()) {
            p.DrawBmp(this.dest);
        }
    }

    public boolean Equals(Mmg9Slice r) {
        return this.GetOffset() == r.GetOffset() && this.GetSrc().Equals(r.GetSrc()) && this.GetDest().Equals(r.GetDest());
    }
}

