/*
 * Decompiled with CFR 0.152.
 */
package net.middlemind.MmgGameApiJava.MmgBase;

import net.middlemind.MmgGameApiJava.MmgBase.MmgDebug;
import net.middlemind.MmgGameApiJava.MmgBase.MmgVector2;

public class MmgPulse {
    private int direction;
    private long timeFlip;
    private long timeTotal;
    private long timeStart;
    private double change;
    private final double changePerMs;
    private long timeDiff;
    private final MmgVector2 baseLineScaling;
    private final MmgVector2 adjScaling;
    private double tmpX;
    private double tmpY;

    public MmgPulse(int startDir, long totalMs, double chng, MmgVector2 blS) {
        this.direction = startDir;
        this.timeTotal = totalMs;
        this.timeFlip = totalMs / 2L;
        this.timeStart = 0L;
        this.change = chng;
        this.baseLineScaling = blS;
        this.adjScaling = new MmgVector2(this.baseLineScaling.GetXDouble() + this.baseLineScaling.GetXDouble() * this.change * (double)this.direction, this.baseLineScaling.GetYDouble() + this.baseLineScaling.GetYDouble() * this.change * (double)this.direction);
        this.changePerMs = (this.adjScaling.GetXDouble() - this.baseLineScaling.GetXDouble()) / (double)this.timeFlip;
        MmgDebug.wr("Direction: " + this.direction);
        MmgDebug.wr("TimeTotal: " + this.timeTotal);
        MmgDebug.wr("TimeFlip: " + this.timeFlip);
        MmgDebug.wr("TimeStart: " + this.timeStart);
        MmgDebug.wr("Change: " + this.change);
        MmgDebug.wr("Change/MS: " + this.changePerMs);
        MmgDebug.wr("MaxX: " + this.adjScaling.GetXDouble());
        MmgDebug.wr("MaxY: " + this.adjScaling.GetYDouble());
        MmgDebug.wr("BaseX: " + this.baseLineScaling.GetXDouble());
        MmgDebug.wr("BaseY: " + this.baseLineScaling.GetYDouble());
    }

    public int GetDirection() {
        return this.direction;
    }

    public void SetDirection(int d) {
        this.direction = d;
    }

    public long GetTimeFlip() {
        return this.timeFlip;
    }

    public void SetTimeFlip(long l) {
        this.timeFlip = l;
    }

    public long GetTimeTotal() {
        return this.timeTotal;
    }

    public void SetTimeTotal(long l) {
        this.timeTotal = l;
    }

    public long GetTimeStart() {
        return this.timeStart;
    }

    public void SetTimeStart(long l) {
        this.timeStart = l;
    }

    public double GetChange() {
        return this.change;
    }

    public void SetChange(double c) {
        this.change = c;
    }

    public void Update(MmgVector2 v) {
        if (this.timeStart == 0L) {
            this.timeStart = System.currentTimeMillis();
        }
        this.timeDiff = System.currentTimeMillis() - this.timeStart;
        this.tmpX = 0.0;
        this.tmpY = 0.0;
        if (this.direction == 1) {
            this.tmpX = this.baseLineScaling.GetXDouble() + this.changePerMs * (double)this.timeDiff;
            this.tmpY = this.baseLineScaling.GetYDouble() + this.changePerMs * (double)this.timeDiff;
        } else if (this.direction == -1) {
            this.tmpX = this.adjScaling.GetXDouble() - this.changePerMs * (double)this.timeDiff;
            this.tmpY = this.adjScaling.GetYDouble() - this.changePerMs * (double)this.timeDiff;
        }
        v.SetX(this.tmpX);
        v.SetY(this.tmpY);
        if (this.timeDiff >= this.timeFlip) {
            this.timeStart = 0L;
            this.direction *= -1;
        }
    }
}

