/*
 * Decompiled with CFR 0.152.
 */
package com.middlemindgames.TyreGame;

import com.middlemindgames.TyreGame.TyreDatGameUtils;
import com.middlemindgames.TyreObjects.TyreObject;

public final class DatConstants {
    public static int CURSOR_CONSOLE_IMG_ID = 0;
    public static int CURSOR_OFFSET_MAIN_MENU_X = 20;
    public static int CURSOR_OFFSET_MAIN_MENU_Y = 10;
    public static int CURSOR_OFFSET_HELP_X = 16;
    public static int CURSOR_OFFSET_HELP_Y = 10;
    public static int CURSOR_OFFSET_HELP_ENEMY_DESC_X = 16;
    public static int CURSOR_OFFSET_HELP_ENEMY_DESC_Y = 10;
    public static int CURSOR_OFFSET_HELP_ITEM_DESC_X = 16;
    public static int CURSOR_OFFSET_HELP_ITEM_DESC_Y = 10;
    public static int CURSOR_OFFSET_HELP_ITEM_TEXT_X = 16;
    public static int CURSOR_OFFSET_HELP_ITEM_TEXT_Y = 10;
    public static int CURSOR_OFFSET_HELP_NPC_DESC_X = 16;
    public static int CURSOR_OFFSET_HELP_NPC_DESC_Y = 10;
    public static String NAME = "TyreDatGame";
    public static String TITLE = "Tyre";
    public static String VERSION = "0.6.71";
    public static String DEVELOPER_COMPANY = "Middlemind Games";
    public static String DEVELOPER_NAME = "Victor G. Brusca";
    public static boolean DEVELOPMENT_MODE_ON = true;
    public static int STRINGS_PROLOGUE = 5;
    public static int STRINGS_EPILOGUE = 533;
    public static int ROOM_WIDTH = 512;
    public static int ROOM_HEIGHT = 320;
    public static int SQUARE_WIDTH = 64;
    public static int SQUARE_HEIGHT = 64;
    public static int TILE_WIDTH = 16;
    public static int TILE_HEIGHT = 16;
    public static int NPC_SPEED = 6;
    public static int NPC_OFFSET_Y = 16;
    public static int PC_SPEED = 8;
    public static int PC_SPEED_INCREMENT = 4;
    public static int PC_OFFSET_Y = 16;
    public static int PC_STARTING_X = 259;
    public static int PC_STARTING_Y = 193;
    public static int PC_STARTING_ROOM = 16;
    public static int PC_ORIG_HEIGHT = 32;
    public static int PC_ORIG_WIDTH = 32;
    public static int DIALOG_INVESTIGATE_WIDTH = 250;
    public static int DIALOG_INVESTIGATE_HEIGHT = 200;
    public static int DIALOG_SEARCH_WIDTH = 250;
    public static int DIALOG_SEARCH_HEIGHT = 200;
    public static int DIALOG_STATS_WIDTH = 400;
    public static int DIALOG_STATS_HEIGHT = 350;
    public static int DIALOG_INVENTORY_WIDTH = 400;
    public static int DIALOG_INVENTORY_HEIGHT = 350;
    public static int DIALOG_ROOM_TEXT_WIDTH = 400;
    public static int DIALOG_ROOM_TEXT_HEIGHT = 350;
    public static int SEARCH_ITEM_HEALING_LV3 = 1;
    public static int SEARCH_ITEM_HEALING_LV3_ODDS = 100;
    public static int SEARCH_ITEM_HEALING_LV3_MAX = 2;
    public static int SEARCH_ITEM_HEALING_LV2 = 13;
    public static int SEARCH_ITEM_HEALING_LV2_ODDS = 50;
    public static int SEARCH_ITEM_HEALING_LV2_MAX = 4;
    public static int SEARCH_ITEM_HEALING_LV1 = 10;
    public static int SEARCH_ITEM_HEALING_LV1_ODDS = 25;
    public static int SEARCH_ITEM_HEALING_LV1_MAX = 6;
    public static int SEARCH_ITEM_ANTIDOTE_LV2 = 8;
    public static int SEARCH_ITEM_ANTIDOTE_LV2_ODDS = 50;
    public static int SEARCH_ITEM_ANTIDOTE_LV2_MAX = 4;
    public static int SEARCH_ITEM_ANTISLEEP_LV2 = 9;
    public static int SEARCH_ITEM_ANTISLEEP_LV2_ODDS = 50;
    public static int SEARCH_ITEM_ANTISLEEP_LV2_MAX = 4;
    public static int SEARCH_ITEM_TORCH_LV1 = 11;
    public static int SEARCH_ITEM_TORCH_LV1_ODDS = 25;
    public static int SEARCH_ITEM_TORCH_LV1_MAX = 2;
    public static int SEARCH_ITEM_TORCH_LV2 = 11;
    public static int SEARCH_ITEM_TORCH_LV2_ODDS = 50;
    public static int SEARCH_ITEM_TORCH_LV2_MAX = 4;
    public static int SEARCH_ITEM_TORCH_LV3 = 11;
    public static int SEARCH_ITEM_TORCH_LV3_ODDS = 100;
    public static int SEARCH_ITEM_TORCH_LV3_MAX = 6;
    public static int SEARCH_ITEM_GOLD_LV1 = 12;
    public static int SEARCH_ITEM_GOLD_LV1_ODDS = 25;
    public static int SEARCH_ITEM_GOLD_LV1_MAX = 25;
    public static int SEARCH_ITEM_GOLD_LV2 = 12;
    public static int SEARCH_ITEM_GOLD_LV2_ODDS = 50;
    public static int SEARCH_ITEM_GOLD_LV2_MAX = 50;
    public static int SEARCH_ITEM_GOLD_LV3 = 12;
    public static int SEARCH_ITEM_GOLD_LV3_ODDS = 100;
    public static int SEARCH_ITEM_GOLD_LV3_MAX = 200;
    public static int SEARCH_ITEM_COUNT = 11;
    public static float ANIMATION_TIME_MS_OVERWORLD_MENU = 250.0f;
    public static float ANIMATION_TIME_MS_OVERWORLD_TALK = 250.0f;
    public static float ANIMATION_TIME_MS_OVERWORLD_INVESTIGATE = 250.0f;
    public static float ANIMATION_TIME_MS_OVERWORLD_SEARCH = 250.0f;
    public static float ANIMATION_TIME_MS_OVERWORLD_STATS = 250.0f;
    public static float ANIMATION_TIME_MS_OVERWORLD_INVENTORY = 250.0f;
    public static float ANIMATION_TIME_MS_OVERWORLD_ROOM_TEXT = 250.0f;
    public static int NPC_DIR_NONE = -1;
    public static int NPC_DIR_FRONT = 0;
    public static int NPC_DIR_BACK = 1;
    public static int NPC_DIR_LEFT = 2;
    public static int NPC_DIR_RIGHT = 3;
    public static int NPC_FEET_LEFT = 0;
    public static int NPC_FEET_CENTER = 1;
    public static int NPC_FEET_RIGHT = 2;
    public static int NPC_STATE_STILL = 0;
    public static int NPC_STATE_WALKING = 1;
    public static int NPC_STATE_PACING = 2;
    public static int NPC_OBJECT_CAN_WALK_OVER = 0;
    public static int NPC_OBJECT_CAN_WALK_UNDER = 1;
    public static int NPC_OBJECT_CANT_WALK_OVER = 2;
    public static int OBJECT_TYPE_CAN_WALK_OVER_DYNAMIC = 12;
    public static int OBJECT_TYPE_OBJECT_SET_CANT_WALK = 11;
    public static int OBJECT_TYPE_OBJECT_SET_ROTATION = 10;
    public static int OBJECT_TYPE_OBJECT_SET = 9;
    public static int OBJECT_TYPE_CAN_WALK_OVER_ROTATION = 8;
    public static int OBJECT_TYPE_HIDDEN_ITEM = 7;
    public static int OBJECT_TYPE_NPC = 6;
    public static int OBJECT_TYPE_ENEMY = 5;
    public static int OBJECT_TYPE_CAN_WALK_OVER_NEGATIVE_POSITION = 4;
    public static int OBJECT_TYPE_PC = 3;
    public static int OBJECT_TYPE_CAN_WALK_UNDER_NEGATIVE_POSITION = 2;
    public static int OBJECT_TYPE_CANT_WALK = 1;
    public static int OBJECT_TYPE_LINK_TABLE = 0;
    public static int SPECIAL_OBJECT_SQUARE_BUSH_ALIVE = 8;
    public static int SPECIAL_OBJECT_SQUARE_BUSH_DEAD = 200;
    public static int SPECIAL_OBJECT_PLANT_2_ALIVE = 284;
    public static int SPECIAL_OBJECT_PLANT_2_DEAD = 35;
    public static int SPECIAL_OBJECT_PLANT_1_ALIVE = 11;
    public static int SPECIAL_OBJECT_PLANT_1_DEAD = 285;
    public static int SPECIAL_OBJECT_SQUARE_BUSH_SNOWY_1_ALIVE = 208;
    public static int SPECIAL_OBJECT_SQUARE_BUSH_SNOWY_2_ALIVE = 209;
    public static int SPECIAL_OBJECT_GRASS_SINGLE_DEAD = 34;
    public static int SPECIAL_OBJECT_GRASS_1_ALIVE = 0;
    public static int SPECIAL_OBJECT_GRASS_1_DEAD = 286;
    public static int SPECIAL_OBJECT_GRASS_2_ALIVE = 1;
    public static int SPECIAL_OBJECT_GRASS_2_DEAD = 287;
    public static int SPECIAL_OBJECT_GRASS_3_ALIVE = 288;
    public static int SPECIAL_OBJECT_GRASS_3_DEAD = 32;
    public static int SPECIAL_OBJECT_PINE_TOP_ALIVE = 29;
    public static int SPECIAL_OBJECT_PINE_TOP_SNOWY_ALIVE = 211;
    public static int SPECIAL_OBJECT_PINE_TOP_SNOWY_DEAD = 212;
    public static int SPECIAL_OBJECT_TILE_SNOW = 43;
    public static int SPECIAL_OBJECT_TILE_SNOW_DARK = 33;
    public static int SPECIAL_OBJECT_TILE_GRASS = 10;
    public static int SPECIAL_OBJECT_TILE_GRASS_DARK = 289;
    public static int OBJECT_TYPE_TILE = -1;
    public static int OBJECT_TYPE_HIDDEN_ITEM_IMAGE = -2;
    public static int ROOM_TYPES_HOUSE_MYSTERIOUS = 3;
    public static int ROOM_TYPES_HOUSE_TUNNEL = 2;
    public static int ROOM_TYPES_HOUSE = 1;
    public static int ROOM_TYPES_HOUSE_WILDERNESS = 0;
    public static int IMAGE_NPC_TREE_FOLK_TRUNK = 9;
    public static int IMAGE_DEATHS_AGENT = 253;
    public static int IMAGE_NOTE = 279;
    public static int IMAGE_BOX = 280;
    public static int IMAGE_NPC_TREE_FOLK = 242;
    public static int TILE_BLUE_CANT_WALK = 23;
    public static int TILE_BLUE = 22;
    public static int TILE_DARK_BROWN_CANT_WALK = 21;
    public static int TILE_HIGH_GROUND_CANT_WALK = 20;
    public static int TILE_HIGH_GROUND = 19;
    public static int TILE_DARK_SNOW_CANT_WALK = 18;
    public static int TILE_SHADOW = 17;
    public static int TILE_DARK_BROWN = 16;
    public static int TILE_DARK_STONE_CANT_WALK = 15;
    public static int TILE_DARK_STONE = 14;
    public static int TILE_STONE_CANT_WALK = 13;
    public static int TILE_STONE = 12;
    public static int TILE_DARK_RED_CANT_WALK = 11;
    public static int TILE_DARK_RED = 10;
    public static int TILE_BROWN_CANT_WALK = 9;
    public static int TILE_GOLD = 8;
    public static int TILE_RED = 7;
    public static int TILE_BLACK_CANT_WALK = 6;
    public static int TILE_SNOW_CANT_WALK = 5;
    public static int TILE_DARK_SNOW = 4;
    public static int TILE_SNOW = 3;
    public static int TILE_GRASS = 2;
    public static int TILE_BLACK = 1;
    public static int TILE_BROWN = 0;
    public static int ITEM_TYPE_SPECIAL_COMBAT = 16;
    public static int ITEM_TYPE_ARMOUR = 15;
    public static int ITEM_TYPE_SWORD = 14;
    public static int ITEM_TYPE_EQUIPMENT = 13;
    public static int ITEM_TYPE_READABLE = 12;
    public static int ITEM_TYPE_RESTORES_PLAYER_HP = 11;
    public static int ITEM_TYPE_ANTISLEEP = 10;
    public static int ITEM_TYPE_ANTIDOTE = 9;
    public static int ITEM_TYPE_OTHER = 8;
    public static int ITEM_TYPE_EFFECTS_PLAYER_HP = 0;
    public static int NPC_TYPE_BAR_KEEPER = 7;
    public static int NPC_TYPE_FRONT_ONLY = 6;
    public static int NPC_TYPE_HEALER = 5;
    public static int NPC_TYPE_TREE_FOLK = 4;
    public static int NPC_TYPE_TOLL_KEEPER = 3;
    public static int NPC_TYPE_ANIMAL = 2;
    public static int NPC_TYPE_PERSON = 1;
    public static int NPC_TYPE_ITEM_SHOP_KEEPER = 0;
    public static int ENEMY_AI_TYPE_PASSIVE = 0;
    public static int ENEMY_AI_TYPE_AGRESSIVE = 1;
    public static int ENEMY_AI_TYPE_MAGIC_DEFENSE = 2;
    public static int ENEMY_AI_TYPE_MAGIC_OFFENSE = 3;
    public static int ENEMY_AI_TYPE_POISONOUS = 4;
    public static int ENEMY_AI_TYPE_ENTRANCING = 5;
    public static int ENEMY_AI_TYPE_VERY_FAST = 6;
    public static int ENEMY_AI_TYPE_MAGIC_SUPPORT = 7;
    public static int ENEMY_AI_TYPE_ACCURATE = 8;
    public static int ENEMY_AI_TYPE_SPECIALIST = 9;
    public static int ENEMY_AI_TYPE_ENTRANCING_WEAK = 10;
    public static int ENEMY_AI_TYPE_ENTRANCING_STRONG = 11;
    public static int ENEMY_AI_TYPE_ENTRANCING_SMART = 12;
    public static int ENEMY_AI_TYPE_POISONOUS_WEAK = 13;
    public static int ENEMY_AI_TYPE_POISONOUS_STRONG = 14;
    public static int ENEMY_AI_TYPE_POISONOUS_SMART = 15;
    public static int ENEMY_AI_TYPE_HEAL_SELF_WEAK = 16;
    public static int ENEMY_AI_TYPE_HEAL_SELF_STRONG = 17;
    public static int ENEMY_AI_TYPE_HEAL_SELF_SMART = 18;
    public static int ENEMY_AI_TYPE_HEAL_ALLY_WEAK = 19;
    public static int ENEMY_AI_TYPE_HEAL_ALLY_STRONG = 20;
    public static int ENEMY_AI_TYPE_HEAL_ALLY_SMART = 21;
    public static int NEGATIVE_ONE = 65535;
    public static final String NEGATIVE_ONE_STR = "65535";

    public static int ForceDeadPlants(int imageId) {
        if (imageId == SPECIAL_OBJECT_SQUARE_BUSH_ALIVE) {
            return SPECIAL_OBJECT_SQUARE_BUSH_DEAD;
        }
        if (imageId == SPECIAL_OBJECT_SQUARE_BUSH_SNOWY_1_ALIVE) {
            return SPECIAL_OBJECT_SQUARE_BUSH_DEAD;
        }
        if (imageId == SPECIAL_OBJECT_SQUARE_BUSH_SNOWY_2_ALIVE) {
            return SPECIAL_OBJECT_SQUARE_BUSH_DEAD;
        }
        if (imageId == SPECIAL_OBJECT_PLANT_1_ALIVE) {
            return SPECIAL_OBJECT_PLANT_1_DEAD;
        }
        if (imageId == SPECIAL_OBJECT_PLANT_2_ALIVE) {
            return SPECIAL_OBJECT_PLANT_2_DEAD;
        }
        if (imageId == SPECIAL_OBJECT_GRASS_1_ALIVE) {
            return SPECIAL_OBJECT_GRASS_1_DEAD;
        }
        if (imageId == SPECIAL_OBJECT_GRASS_2_ALIVE) {
            return SPECIAL_OBJECT_GRASS_2_DEAD;
        }
        if (imageId == SPECIAL_OBJECT_GRASS_3_ALIVE) {
            return SPECIAL_OBJECT_GRASS_3_DEAD;
        }
        if (imageId == SPECIAL_OBJECT_PINE_TOP_ALIVE) {
            return SPECIAL_OBJECT_PINE_TOP_SNOWY_DEAD;
        }
        if (imageId == SPECIAL_OBJECT_PINE_TOP_SNOWY_ALIVE) {
            return SPECIAL_OBJECT_PINE_TOP_SNOWY_DEAD;
        }
        return imageId;
    }

    public static int ForceAlivePlants(int imageId) {
        if (imageId == SPECIAL_OBJECT_SQUARE_BUSH_DEAD) {
            int tmp = TyreDatGameUtils.GetRandomInt(3);
            if (tmp == 0) {
                return SPECIAL_OBJECT_SQUARE_BUSH_ALIVE;
            }
            if (tmp == 1) {
                return SPECIAL_OBJECT_SQUARE_BUSH_SNOWY_1_ALIVE;
            }
            if (tmp == 2) {
                return SPECIAL_OBJECT_SQUARE_BUSH_SNOWY_2_ALIVE;
            }
            return imageId;
        }
        if (imageId == SPECIAL_OBJECT_PLANT_1_DEAD) {
            return SPECIAL_OBJECT_PLANT_1_ALIVE;
        }
        if (imageId == SPECIAL_OBJECT_PLANT_2_DEAD) {
            return SPECIAL_OBJECT_PLANT_2_ALIVE;
        }
        if (imageId == SPECIAL_OBJECT_GRASS_1_DEAD) {
            return SPECIAL_OBJECT_GRASS_1_ALIVE;
        }
        if (imageId == SPECIAL_OBJECT_GRASS_2_DEAD) {
            return SPECIAL_OBJECT_GRASS_2_ALIVE;
        }
        if (imageId == SPECIAL_OBJECT_GRASS_3_DEAD) {
            return SPECIAL_OBJECT_GRASS_3_ALIVE;
        }
        if (imageId == SPECIAL_OBJECT_PINE_TOP_SNOWY_DEAD) {
            int tmp = TyreDatGameUtils.GetRandomInt(3);
            if (tmp == 0) {
                return SPECIAL_OBJECT_PINE_TOP_ALIVE;
            }
            if (tmp == 1) {
                return SPECIAL_OBJECT_PINE_TOP_SNOWY_ALIVE;
            }
            if (tmp == 2) {
                return SPECIAL_OBJECT_PINE_TOP_SNOWY_DEAD;
            }
            return imageId;
        }
        return imageId;
    }

    public static int ForceNoSnow(int tileImageId) {
        if (tileImageId == SPECIAL_OBJECT_TILE_SNOW) {
            return SPECIAL_OBJECT_TILE_GRASS;
        }
        if (tileImageId == SPECIAL_OBJECT_TILE_SNOW_DARK) {
            return SPECIAL_OBJECT_TILE_GRASS_DARK;
        }
        return tileImageId;
    }

    public static final String EnemyAiTypeToString(int i) {
        String ret = "Unknown";
        if (i == ENEMY_AI_TYPE_PASSIVE) {
            ret = "Passive";
        } else if (i == ENEMY_AI_TYPE_AGRESSIVE) {
            ret = "Aggressive";
        } else if (i == ENEMY_AI_TYPE_MAGIC_DEFENSE) {
            ret = "Magic Defense";
        } else if (i == ENEMY_AI_TYPE_MAGIC_OFFENSE) {
            ret = "Magic Offense";
        } else if (i == ENEMY_AI_TYPE_POISONOUS) {
            ret = "Poisonous";
        } else if (i == ENEMY_AI_TYPE_ENTRANCING) {
            ret = "Entrancing";
        } else if (i == ENEMY_AI_TYPE_VERY_FAST) {
            ret = "Very Fast";
        } else if (i == ENEMY_AI_TYPE_MAGIC_SUPPORT) {
            ret = "Magic Support";
        } else if (i == ENEMY_AI_TYPE_ACCURATE) {
            ret = "Accurate";
        } else if (i == ENEMY_AI_TYPE_SPECIALIST) {
            ret = "Specialist";
        } else if (i == ENEMY_AI_TYPE_ENTRANCING_WEAK) {
            ret = "Entrancing Weak";
        } else if (i == ENEMY_AI_TYPE_ENTRANCING_STRONG) {
            ret = "Entrancing Strong";
        } else if (i == ENEMY_AI_TYPE_ENTRANCING_SMART) {
            ret = "Entrancing Smart";
        } else if (i == ENEMY_AI_TYPE_POISONOUS_WEAK) {
            ret = "Poisonous Weak";
        } else if (i == ENEMY_AI_TYPE_POISONOUS_STRONG) {
            ret = "Poisonous Strong";
        } else if (i == ENEMY_AI_TYPE_POISONOUS_SMART) {
            ret = "Poisonous Smart";
        } else if (i == ENEMY_AI_TYPE_HEAL_ALLY_WEAK) {
            ret = "Heal Ally Weak";
        } else if (i == ENEMY_AI_TYPE_HEAL_ALLY_STRONG) {
            ret = "Heal Ally Strong";
        } else if (i == ENEMY_AI_TYPE_HEAL_ALLY_SMART) {
            ret = "Heal Ally Smart";
        } else if (i == ENEMY_AI_TYPE_HEAL_SELF_WEAK) {
            ret = "Heal Self Weak";
        } else if (i == ENEMY_AI_TYPE_HEAL_SELF_STRONG) {
            ret = "Heal Self Strong";
        } else if (i == ENEMY_AI_TYPE_HEAL_SELF_SMART) {
            ret = "Heal Self Smart";
        }
        return ret;
    }

    public static final String CleanNegativeOnes(String s) {
        return s.replace(NEGATIVE_ONE_STR, "-1");
    }

    public static final String CleanNegativeOnes(String s, String r) {
        return s.replace(NEGATIVE_ONE_STR, r);
    }

    public static final String BoolToString(boolean b) {
        if (b) {
            return "On";
        }
        return "Off";
    }

    public static final String BoolToStringLower(boolean b) {
        if (b) {
            return "on";
        }
        return "Off";
    }

    public static final String BoolToStringUpper(boolean b) {
        if (b) {
            return "ON";
        }
        return "OFF";
    }

    public static final boolean IsBadIndex(int i) {
        return i == 65535 || i == -1;
    }

    public static final String BoolToStringBool(int b) {
        String ret = "Unknown";
        if (b == 0) {
            ret = "False";
        } else if (b == 1) {
            ret = "True";
        }
        return ret;
    }

    public static final String BoolToStringYesNo(int b) {
        String ret = "Unknown";
        if (b == 0) {
            ret = "No";
        } else if (b == 1) {
            ret = "Yes";
        }
        return ret;
    }

    public static final String BoolToStringBool(boolean b) {
        String ret = "Unknown";
        if (!b) {
            ret = "False";
        } else if (b) {
            ret = "True";
        }
        return ret;
    }

    public static final String BoolToStringYesNo(boolean b) {
        String ret = "Unknown";
        if (!b) {
            ret = "No";
        } else if (b) {
            ret = "Yes";
        }
        return ret;
    }

    public static final String NpcDirToString(int iDir) {
        String ret = "None";
        if (iDir == NPC_DIR_FRONT) {
            ret = "Front";
        } else if (iDir == NPC_DIR_BACK) {
            ret = "Back";
        } else if (iDir == NPC_DIR_LEFT) {
            ret = "Left";
        } else if (iDir == NPC_DIR_RIGHT) {
            ret = "Right";
        }
        return ret;
    }

    public static final String ItemTypeToString(int iType) {
        String ret = "Unknown";
        if (iType == ITEM_TYPE_ANTIDOTE) {
            ret = "Antitode";
        } else if (iType == ITEM_TYPE_ANTISLEEP) {
            ret = "Antisleep";
        } else if (iType == ITEM_TYPE_ARMOUR) {
            ret = "Armor";
        } else if (iType == ITEM_TYPE_EFFECTS_PLAYER_HP) {
            ret = "Concoction";
        } else if (iType == ITEM_TYPE_EQUIPMENT) {
            ret = "Equipment";
        } else if (iType == ITEM_TYPE_OTHER) {
            ret = "Misc.";
        } else if (iType == ITEM_TYPE_READABLE) {
            ret = "Readable";
        } else if (iType == ITEM_TYPE_RESTORES_PLAYER_HP) {
            ret = "Healing";
        } else if (iType == ITEM_TYPE_SPECIAL_COMBAT) {
            ret = "Special";
        } else if (iType == ITEM_TYPE_SWORD) {
            ret = "Sword";
        }
        return ret;
    }

    public static final String NpcTypeToString(int iType) {
        String ret = "Unknown";
        if (iType == NPC_TYPE_ANIMAL) {
            ret = "Animal";
        } else if (iType == NPC_TYPE_BAR_KEEPER) {
            ret = "Bar Keeper";
        } else if (iType == NPC_TYPE_FRONT_ONLY) {
            ret = "Front Only";
        } else if (iType == NPC_TYPE_HEALER) {
            ret = "Healer";
        } else if (iType == NPC_TYPE_ITEM_SHOP_KEEPER) {
            ret = "Shop Keeper";
        } else if (iType == NPC_TYPE_PERSON) {
            ret = "Person";
        } else if (iType == NPC_TYPE_TOLL_KEEPER) {
            ret = "Toll Keeper";
        } else if (iType == NPC_TYPE_TREE_FOLK) {
            ret = "Tree Folk";
        }
        return ret;
    }

    public static final String NpcStateToString(int iType) {
        String ret = "Unknown";
        if (iType == NPC_STATE_STILL) {
            ret = "Still";
        } else if (iType == NPC_STATE_PACING) {
            ret = "Pacing";
        } else if (iType == NPC_STATE_WALKING) {
            ret = "Walking";
        }
        return ret;
    }

    public static final String ObjectToString(TyreObject obj) {
        String ret = DatConstants.ObjectTypeToString(obj.GetType());
        if (obj.IsPcFake()) {
            ret = ret + " - PC Place Holder";
        }
        if (obj.IsTreeFolk()) {
            ret = ret + " - NPC TreeFolk";
        }
        return ret;
    }

    public static final String ObjectTypeToString(int iType) {
        String ret = "Unknown";
        if (iType == OBJECT_TYPE_CANT_WALK) {
            ret = "Can't Walk";
        } else if (iType == OBJECT_TYPE_CAN_WALK_OVER_DYNAMIC) {
            ret = "Can Walk Over Dynamic";
        } else if (iType == OBJECT_TYPE_CAN_WALK_OVER_NEGATIVE_POSITION) {
            ret = "Can Walk Over Negative Position";
        } else if (iType == OBJECT_TYPE_CAN_WALK_OVER_ROTATION) {
            ret = "Can Walk Over with Rotation";
        } else if (iType == OBJECT_TYPE_CAN_WALK_UNDER_NEGATIVE_POSITION) {
            ret = "Can Walk Under Negative Position";
        } else if (iType == OBJECT_TYPE_ENEMY) {
            ret = "Enemy Battle";
        } else if (iType == OBJECT_TYPE_HIDDEN_ITEM) {
            ret = "Hidden Item";
        } else if (iType == OBJECT_TYPE_HIDDEN_ITEM_IMAGE) {
            ret = "Hidden Item Image";
        } else if (iType == OBJECT_TYPE_LINK_TABLE) {
            ret = "Link Table Jump";
        } else if (iType == OBJECT_TYPE_NPC) {
            ret = "NPC";
        } else if (iType == OBJECT_TYPE_OBJECT_SET) {
            ret = "Object Set";
        } else if (iType == OBJECT_TYPE_OBJECT_SET_CANT_WALK) {
            ret = "Can't Walk Object Set";
        } else if (iType == OBJECT_TYPE_OBJECT_SET_ROTATION) {
            ret = "Object Set with Rotation";
        } else if (iType == OBJECT_TYPE_PC) {
            ret = "PC";
        } else if (iType == OBJECT_TYPE_TILE) {
            ret = "Tile";
        }
        return ret;
    }
}

