/*
 * Decompiled with CFR 0.152.
 */
package com.middlemindgames.TyreGame;

import com.middlemindgames.TyreGame.DatConstants;
import com.middlemindgames.TyreGame.GenericEventHandler;
import com.middlemindgames.TyreGame.GenericEventMessage;
import com.middlemindgames.TyreGame.MainFrame;
import com.middlemindgames.TyreGame.ScreenAbout;
import com.middlemindgames.TyreGame.ScreenHelp;
import com.middlemindgames.TyreGame.ScreenHelpEnemyDesc;
import com.middlemindgames.TyreGame.ScreenHelpGamePlayBattleMode;
import com.middlemindgames.TyreGame.ScreenHelpGamePlayOverworld;
import com.middlemindgames.TyreGame.ScreenHelpItemDesc;
import com.middlemindgames.TyreGame.ScreenHelpItemDescItemText;
import com.middlemindgames.TyreGame.ScreenHelpNpcDesc;
import com.middlemindgames.TyreGame.ScreenHelpPrologue;
import com.middlemindgames.TyreGame.ScreenHelpQuestDesc;
import com.middlemindgames.TyreGame.ScreenHelpRoomDesc;
import com.middlemindgames.TyreGame.ScreenHelpRoomDescRoomDetails;
import com.middlemindgames.TyreGame.ScreenLoading;
import com.middlemindgames.TyreGame.ScreenMainGame;
import com.middlemindgames.TyreGame.ScreenMainMenu;
import com.middlemindgames.TyreGame.ScreenSettings;
import com.middlemindgames.TyreGame.ScreenSplash;
import com.middlemindgames.TyreGame.TyreDatGameUtils;
import com.middlemindgames.TyreObjects.TyrePc;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import net.middlemind.MmgGameApiJava.MmgBase.MmgBmpScaler;
import net.middlemind.MmgGameApiJava.MmgBase.MmgFontData;
import net.middlemind.MmgGameApiJava.MmgBase.MmgGameScreen;
import net.middlemind.MmgGameApiJava.MmgBase.MmgHelper;
import net.middlemind.MmgGameApiJava.MmgBase.MmgPen;
import net.middlemind.MmgGameApiJava.MmgBase.MmgScreenData;

public class GamePanel
implements GenericEventHandler {
    private final MainFrame mf;
    private final int winWidth;
    private final int winHeight;
    private final int myX;
    private final int myY;
    private final int sWinWidth;
    private final int sWinHeight;
    private final int sMyX;
    private final int sMyY;
    public static final int GAME_WIDTH = 854;
    public static final int GAME_HEIGHT = 416;
    public static boolean PAUSE = false;
    public static boolean EXIT = false;
    private Graphics2D g2d;
    private Hashtable<GameStates, MmgGameScreen> gameScreens;
    private MmgGameScreen currentScreen;
    private final MmgPen p;
    private final ScreenLoading loadingScreen;
    private final ScreenSplash splashScreen;
    private final ScreenMainMenu mainMenuScreen;
    private final ScreenAbout aboutScreen;
    private final ScreenHelp helpScreen;
    private final ScreenHelpPrologue helpPrologueScreen;
    private final ScreenHelpItemDesc helpItemDescScreen;
    private final ScreenHelpItemDescItemText helpItemDescItemTextScreen;
    private final ScreenHelpEnemyDesc helpEnemyDescScreen;
    private final ScreenHelpGamePlayOverworld helpGameOverworldScreen;
    private final ScreenHelpGamePlayBattleMode helpGameBattleModeScreen;
    private final ScreenHelpNpcDesc helpCharDescScreen;
    private final ScreenHelpQuestDesc helpQuestDescScreen;
    private final ScreenHelpRoomDesc helpRoomDescScreen;
    private final ScreenHelpRoomDescRoomDetails helpRoomDescRoomDetailsScreen;
    private final ScreenMainGame mainGameScreen;
    private final ScreenSettings settingsScreen;
    private GameStates prevGameState;
    private GameStates gameState;
    public static Hashtable<String, Object> VARS = new Hashtable();
    public static String FPS = "Drawing FPS: 0000 Actual FPS: 00";
    public static String VAR1 = "** EMPTY **";
    public static String VAR2 = "** EMPTY **";
    public Canvas canvas;
    private BufferStrategy strategy;
    private BufferedImage background;
    private Graphics2D backgroundGraphics;
    private Graphics2D graphics;
    private final double scale = 1.0;
    private int updateTick = 0;
    private long now;
    private long prev;
    private final Font debugFont;
    private Font tmpF;
    public static TyrePc PC;
    public static ScreenMainGame SCREEN_MAIN_GAME;
    public static GameType GAME_TYPE;
    public int lastX;
    public int lastY;
    public long lastKeyPressEvent = -1L;
    private Graphics2D bg;
    private Graphics2D g;

    public GamePanel(MainFrame Mf, int WinWidth, int WinHeight, int X, int Y) {
        PC = null;
        this.mf = Mf;
        this.winWidth = WinWidth;
        this.winHeight = WinHeight;
        this.sWinWidth = (int)((double)this.winWidth * 1.0);
        this.sWinHeight = (int)((double)this.winHeight * 1.0);
        this.myX = X;
        this.myY = Y;
        this.sMyX = this.myX + (this.winWidth - this.sWinWidth);
        this.sMyY = this.myY + (this.winHeight - this.sWinHeight);
        this.now = System.currentTimeMillis();
        this.prev = System.currentTimeMillis();
        this.canvas = new Canvas(MmgBmpScaler.GRAPHICS_CONFIG);
        this.canvas.setSize(this.winWidth, this.winHeight);
        TyreDatGameUtils.wr("GamePanel Window Width: " + this.winWidth);
        TyreDatGameUtils.wr("GamePanel Window Height: " + this.winHeight);
        TyreDatGameUtils.wr("GamePanel Offset X: " + this.myX);
        TyreDatGameUtils.wr("GamePanel Offset Y: " + this.myY);
        MmgScreenData screenData = new MmgScreenData(this.winWidth, this.winHeight, 854, 416);
        TyreDatGameUtils.wr(MmgScreenData.ToString());
        MmgFontData fontData = new MmgFontData();
        TyreDatGameUtils.wr(MmgFontData.ToString());
        this.debugFont = MmgFontData.CreateDefaultFontSm();
        this.p = new MmgPen();
        MmgPen.ADV_RENDER_HINTS = true;
        this.loadingScreen = new ScreenLoading(GameStates.LOADING, this);
        this.loadingScreen.SetGenericEventHandler(this);
        this.splashScreen = new ScreenSplash(GameStates.SPLASH, this);
        this.splashScreen.SetGenericEventHandler(this);
        this.mainMenuScreen = new ScreenMainMenu(GameStates.MAIN_MENU, this);
        this.aboutScreen = new ScreenAbout(GameStates.ABOUT, this);
        this.helpScreen = new ScreenHelp(GameStates.HELP_MENU, this);
        this.helpPrologueScreen = new ScreenHelpPrologue(GameStates.HELP_PROLOGUE, this);
        this.helpItemDescScreen = new ScreenHelpItemDesc(GameStates.HELP_ITEM_DESC, this);
        this.helpItemDescItemTextScreen = new ScreenHelpItemDescItemText(GameStates.HELP_ITEM_DESC_ITEM_TEXT, this);
        this.helpEnemyDescScreen = new ScreenHelpEnemyDesc(GameStates.HELP_ENEMY_DESC, this);
        this.helpGameOverworldScreen = new ScreenHelpGamePlayOverworld(GameStates.HELP_GAME_PLAY_OVERWORLD, this);
        this.helpGameBattleModeScreen = new ScreenHelpGamePlayBattleMode(GameStates.HELP_GAME_PLAY_BATTLE_MODE, this);
        this.helpCharDescScreen = new ScreenHelpNpcDesc(GameStates.HELP_CHAR_DESC, this);
        this.helpQuestDescScreen = new ScreenHelpQuestDesc(GameStates.HELP_QUEST_DESC, this);
        this.helpRoomDescScreen = new ScreenHelpRoomDesc(GameStates.HELP_ROOM_DESC, this);
        this.helpRoomDescRoomDetailsScreen = new ScreenHelpRoomDescRoomDetails(GameStates.HELP_ROOM_DESC_ROOM_DETAILS, this);
        this.mainGameScreen = new ScreenMainGame(GameStates.MAIN_GAME, this);
        this.settingsScreen = new ScreenSettings(GameStates.SETTINGS, this);
        SCREEN_MAIN_GAME = this.mainGameScreen;
        this.gameScreens = new Hashtable(20);
        this.gameScreens.put(GameStates.LOADING, (MmgGameScreen)this.loadingScreen);
        this.gameScreens.put(GameStates.SPLASH, (MmgGameScreen)this.splashScreen);
        this.gameScreens.put(GameStates.MAIN_MENU, this.mainMenuScreen);
        this.gameScreens.put(GameStates.ABOUT, this.aboutScreen);
        this.gameScreens.put(GameStates.HELP_MENU, this.helpScreen);
        this.gameScreens.put(GameStates.HELP_PROLOGUE, this.helpPrologueScreen);
        this.gameScreens.put(GameStates.HELP_ITEM_DESC, this.helpItemDescScreen);
        this.gameScreens.put(GameStates.HELP_ITEM_DESC_ITEM_TEXT, this.helpItemDescItemTextScreen);
        this.gameScreens.put(GameStates.HELP_ENEMY_DESC, this.helpEnemyDescScreen);
        this.gameScreens.put(GameStates.HELP_GAME_PLAY_OVERWORLD, this.helpGameOverworldScreen);
        this.gameScreens.put(GameStates.HELP_GAME_PLAY_BATTLE_MODE, this.helpGameBattleModeScreen);
        this.gameScreens.put(GameStates.HELP_CHAR_DESC, this.helpCharDescScreen);
        this.gameScreens.put(GameStates.HELP_QUEST_DESC, this.helpQuestDescScreen);
        this.gameScreens.put(GameStates.HELP_ROOM_DESC, this.helpRoomDescScreen);
        this.gameScreens.put(GameStates.HELP_ROOM_DESC_ROOM_DETAILS, this.helpRoomDescRoomDetailsScreen);
        this.gameScreens.put(GameStates.MAIN_GAME, this.mainGameScreen);
        this.gameScreens.put(GameStates.SETTINGS, this.settingsScreen);
        this.gameState = GameStates.BLANK;
        this.SwitchGameState(GameStates.SPLASH);
        this.canvas.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                GamePanel.this.lastX = e.getX();
                GamePanel.this.lastY = e.getY();
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                GamePanel.this.lastX = e.getX();
                GamePanel.this.lastY = e.getY();
            }
        });
        this.canvas.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == ' ' || e.getKeyChar() == '\n') {
                    GamePanel.this.ProcessClick(GamePanel.this.lastX, GamePanel.this.lastY);
                } else if (e.getKeyChar() == '+') {
                    GamePanel.PC.SPEED += MmgHelper.ScaleValue((int)DatConstants.PC_SPEED_INCREMENT) + 1;
                } else if (e.getKeyChar() == '-') {
                    GamePanel.PC.SPEED -= MmgHelper.ScaleValue((int)DatConstants.PC_SPEED_INCREMENT) - 1;
                } else if (e.getKeyChar() == 'p' || e.getKeyChar() == 'P') {
                    if (GamePanel.this.gameState == GameStates.MAIN_GAME) {
                        GamePanel.this.mainGameScreen.ToggleOverworldPause();
                    }
                } else if (e.getKeyChar() == 'a' || e.getKeyChar() == 'A') {
                    GamePanel.this.ProcessAClick();
                } else if (e.getKeyChar() == 'b' || e.getKeyChar() == 'B') {
                    GamePanel.this.ProcessBClick();
                } else if (e.getKeyChar() == 'd' || e.getKeyChar() == 'D') {
                    GamePanel.this.ProcessDebugClick();
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() != 32 && e.getKeyCode() != 10) {
                    GamePanel.this.lastKeyPressEvent = System.currentTimeMillis();
                    if (e.getKeyCode() == 40) {
                        GamePanel.this.ProcessDpadPress(DatConstants.NPC_DIR_FRONT);
                    } else if (e.getKeyCode() == 38) {
                        GamePanel.this.ProcessDpadPress(DatConstants.NPC_DIR_BACK);
                    } else if (e.getKeyCode() == 37) {
                        GamePanel.this.ProcessDpadPress(DatConstants.NPC_DIR_LEFT);
                    } else if (e.getKeyCode() == 39) {
                        GamePanel.this.ProcessDpadPress(DatConstants.NPC_DIR_RIGHT);
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() != 32 && e.getKeyCode() != 10) {
                    if (e.getKeyCode() == 40) {
                        GamePanel.this.ProcessDpadRelease(DatConstants.NPC_DIR_FRONT);
                    } else if (e.getKeyCode() == 38) {
                        GamePanel.this.ProcessDpadRelease(DatConstants.NPC_DIR_BACK);
                    } else if (e.getKeyCode() == 37) {
                        GamePanel.this.ProcessDpadRelease(DatConstants.NPC_DIR_LEFT);
                    } else if (e.getKeyCode() == 39) {
                        GamePanel.this.ProcessDpadRelease(DatConstants.NPC_DIR_RIGHT);
                    }
                }
            }
        });
        this.canvas.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                GamePanel.this.ProcessClick(e.getX(), e.getY());
            }

            @Override
            public void mousePressed(MouseEvent e) {
                GamePanel.this.ProcessPress(e.getX(), e.getY());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                GamePanel.this.ProcessRelease(e.getX(), e.getY());
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
    }

    public final void ProcessAClick() {
        this.currentScreen.ProcessAClick();
    }

    public final void ProcessBClick() {
        if (this.gameState == GameStates.MAIN_GAME) {
            this.mainGameScreen.ProcessBClick();
        }
    }

    public final void ProcessDebugClick() {
        if (this.gameState == GameStates.MAIN_GAME) {
            this.mainGameScreen.ProcessDebugClick();
        }
    }

    public final void ProcessDpadPress(int dir) {
        if (this.gameState == GameStates.MAIN_GAME) {
            this.mainGameScreen.ProcessDpadPress(dir);
        }
    }

    public final void ProcessDpadRelease(int dir) {
        if (this.gameState == GameStates.MAIN_GAME) {
            this.mainGameScreen.ProcessDpadRelease(dir);
        } else if (this.gameState == GameStates.MAIN_MENU) {
            this.mainMenuScreen.ProcessDpadRelease(dir);
        } else if (this.gameState == GameStates.HELP_MENU) {
            this.helpScreen.ProcessDpadRelease(dir);
        } else if (this.gameState == GameStates.HELP_ENEMY_DESC) {
            this.helpEnemyDescScreen.ProcessDpadRelease(dir);
        } else if (this.gameState == GameStates.HELP_ITEM_DESC) {
            this.helpItemDescScreen.ProcessDpadRelease(dir);
        } else if (this.gameState == GameStates.HELP_ITEM_DESC_ITEM_TEXT) {
            this.helpItemDescItemTextScreen.ProcessDpadRelease(dir);
        } else if (this.gameState == GameStates.HELP_CHAR_DESC) {
            this.helpCharDescScreen.ProcessDpadRelease(dir);
        }
    }

    public final void ProcessPress(int x, int y) {
        int nx = x;
        int ny = y;
        int anx = x - MmgScreenData.GetGameLeft() - this.myX;
        int any = y - MmgScreenData.GetGameTop() - this.myY;
        if (this.gameState == GameStates.MAIN_GAME) {
            this.mainGameScreen.ProcessScreenPress(anx, any);
        }
    }

    public final void ProcessRelease(int x, int y) {
        int nx = x;
        int ny = y;
        int anx = x - MmgScreenData.GetGameLeft() - this.myX;
        int any = y - MmgScreenData.GetGameTop() - this.myY;
        if (this.gameState == GameStates.MAIN_GAME) {
            this.mainGameScreen.ProcessScreenRelease(anx, any);
        }
    }

    public final void ProcessClick(int x, int y) {
        int nx = x;
        int ny = y;
        int anx = x - MmgScreenData.GetGameLeft() - this.myX;
        int any = y - MmgScreenData.GetGameTop() - this.myY;
        if (this.gameState == GameStates.MAIN_MENU) {
            this.mainMenuScreen.ProcessScreenClick(nx, ny);
        } else if (this.gameState == GameStates.ABOUT) {
            this.aboutScreen.ProcessScreenClick(nx, ny);
        } else if (this.gameState == GameStates.HELP_MENU) {
            this.helpScreen.ProcessScreenClick(nx, ny);
        } else if (this.gameState == GameStates.HELP_PROLOGUE) {
            this.helpPrologueScreen.ProcessScreenClick(nx, ny);
        } else if (this.gameState == GameStates.HELP_ITEM_DESC) {
            this.helpItemDescScreen.ProcessScreenClick(nx, ny);
        } else if (this.gameState == GameStates.HELP_ITEM_DESC_ITEM_TEXT) {
            this.helpItemDescItemTextScreen.ProcessScreenClick(nx, ny);
        } else if (this.gameState == GameStates.HELP_ENEMY_DESC) {
            this.helpEnemyDescScreen.ProcessScreenClick(nx, ny);
        } else if (this.gameState == GameStates.HELP_GAME_PLAY_OVERWORLD) {
            this.helpGameOverworldScreen.ProcessScreenClick(nx, ny);
        } else if (this.gameState == GameStates.HELP_GAME_PLAY_BATTLE_MODE) {
            this.helpGameBattleModeScreen.ProcessScreenClick(nx, ny);
        } else if (this.gameState == GameStates.HELP_CHAR_DESC) {
            this.helpCharDescScreen.ProcessScreenClick(nx, ny);
        } else if (this.gameState == GameStates.HELP_QUEST_DESC) {
            this.helpQuestDescScreen.ProcessScreenClick(nx, ny);
        } else if (this.gameState == GameStates.HELP_ROOM_DESC) {
            this.helpRoomDescScreen.ProcessScreenClick(nx, ny);
        } else if (this.gameState == GameStates.HELP_ROOM_DESC_ROOM_DETAILS) {
            this.helpRoomDescRoomDetailsScreen.ProcessScreenClick(nx, ny);
        } else if (this.gameState != GameStates.MAIN_GAME && this.gameState == GameStates.SETTINGS) {
            this.settingsScreen.ProcessScreenClick(nx, ny);
        }
    }

    public final void PrepBuffers() {
        this.background = this.create(this.winWidth, this.winHeight, false);
        this.canvas.createBufferStrategy(2);
        do {
            this.strategy = this.canvas.getBufferStrategy();
        } while (this.strategy == null);
        this.backgroundGraphics = (Graphics2D)this.background.getGraphics();
    }

    public final BufferedImage create(int width, int height, boolean alpha) {
        return MmgBmpScaler.GRAPHICS_CONFIG.createCompatibleImage(width, height, alpha ? 3 : 1);
    }

    public final Hashtable<GameStates, MmgGameScreen> GetGameScreens() {
        return this.gameScreens;
    }

    public final void SetGameScreens(Hashtable<GameStates, MmgGameScreen> GameScreens) {
        this.gameScreens = GameScreens;
    }

    public final MmgGameScreen GetCurrentScreen() {
        return this.currentScreen;
    }

    public final void SetCurrentScreen(MmgGameScreen CurrentScreen) {
        this.currentScreen = CurrentScreen;
    }

    public final void SwitchGameState(GameStates g) {
        TyreDatGameUtils.wr("Switching Game State To: " + (Object)((Object)g));
        if (this.gameState != this.prevGameState) {
            this.prevGameState = this.gameState;
        }
        if (g == this.gameState) {
            return;
        }
        this.gameState = g;
        if (this.prevGameState == GameStates.BLANK) {
            TyreDatGameUtils.wr("Hiding BLANK screen.");
        } else if (this.prevGameState == GameStates.LOADING) {
            TyreDatGameUtils.wr("Hiding LOADING screen.");
            this.loadingScreen.Pause();
            this.loadingScreen.SetIsVisible(false);
            this.loadingScreen.UnloadResources();
            TyreDatGameUtils.wr("Hiding LOADING screen DONE.");
        } else if (this.prevGameState == GameStates.SPLASH) {
            TyreDatGameUtils.wr("Hiding SPLASH screen.");
            this.splashScreen.Pause();
            this.splashScreen.SetIsVisible(false);
            this.splashScreen.UnloadResources();
        } else if (this.prevGameState == GameStates.MAIN_MENU) {
            TyreDatGameUtils.wr("Hiding MAIN_MENU screen.");
            this.mainMenuScreen.Pause();
            this.mainMenuScreen.SetIsVisible(false);
            this.mainMenuScreen.UnloadResources();
        } else if (this.prevGameState == GameStates.ABOUT) {
            TyreDatGameUtils.wr("Hiding ABOUT screen.");
            this.aboutScreen.Pause();
            this.aboutScreen.SetIsVisible(false);
            this.aboutScreen.UnloadResources();
        } else if (this.prevGameState == GameStates.HELP_MENU) {
            TyreDatGameUtils.wr("Hiding HELP screen.");
            this.helpScreen.Pause();
            this.helpScreen.SetIsVisible(false);
            this.helpScreen.UnloadResources();
        } else if (this.prevGameState == GameStates.HELP_PROLOGUE) {
            TyreDatGameUtils.wr("Hiding HELP PROLOGUE screen.");
            this.helpPrologueScreen.Pause();
            this.helpPrologueScreen.SetIsVisible(false);
            this.helpPrologueScreen.UnloadResources();
        } else if (this.prevGameState == GameStates.HELP_ITEM_DESC) {
            TyreDatGameUtils.wr("Hiding HELP ITEM DESC screen.");
            this.helpItemDescScreen.Pause();
            this.helpItemDescScreen.SetIsVisible(false);
            this.helpItemDescScreen.UnloadResources();
        } else if (this.prevGameState == GameStates.HELP_ITEM_DESC_ITEM_TEXT) {
            TyreDatGameUtils.wr("Hiding HELP ITEM DESC ITEM TEXT screen.");
            this.helpItemDescItemTextScreen.Pause();
            this.helpItemDescItemTextScreen.SetIsVisible(false);
            this.helpItemDescItemTextScreen.UnloadResources();
        } else if (this.prevGameState == GameStates.HELP_ENEMY_DESC) {
            TyreDatGameUtils.wr("Hiding HELP ENEMY DESC screen.");
            this.helpEnemyDescScreen.Pause();
            this.helpEnemyDescScreen.SetIsVisible(false);
            this.helpEnemyDescScreen.UnloadResources();
        } else if (this.prevGameState == GameStates.HELP_GAME_PLAY_OVERWORLD) {
            TyreDatGameUtils.wr("Hiding HELP GAME OVERWORLD screen.");
            this.helpGameOverworldScreen.Pause();
            this.helpGameOverworldScreen.SetIsVisible(false);
            this.helpGameOverworldScreen.UnloadResources();
        } else if (this.prevGameState == GameStates.HELP_GAME_PLAY_BATTLE_MODE) {
            TyreDatGameUtils.wr("Hiding HELP GAME BATTLE MODE screen.");
            this.helpGameBattleModeScreen.Pause();
            this.helpGameBattleModeScreen.SetIsVisible(false);
            this.helpGameBattleModeScreen.UnloadResources();
        } else if (this.prevGameState == GameStates.HELP_CHAR_DESC) {
            TyreDatGameUtils.wr("Hiding HELP CHAR DESC screen.");
            this.helpCharDescScreen.Pause();
            this.helpCharDescScreen.SetIsVisible(false);
            this.helpCharDescScreen.UnloadResources();
        } else if (this.prevGameState == GameStates.HELP_QUEST_DESC) {
            TyreDatGameUtils.wr("Hiding HELP QUEST DESC screen.");
            this.helpQuestDescScreen.Pause();
            this.helpQuestDescScreen.SetIsVisible(false);
            this.helpQuestDescScreen.UnloadResources();
        } else if (this.prevGameState == GameStates.HELP_ROOM_DESC) {
            TyreDatGameUtils.wr("Hiding HELP ROOM DESC screen.");
            this.helpRoomDescScreen.Pause();
            this.helpRoomDescScreen.SetIsVisible(false);
            this.helpRoomDescScreen.UnloadResources();
        } else if (this.prevGameState == GameStates.HELP_ROOM_DESC_ROOM_DETAILS) {
            TyreDatGameUtils.wr("Hiding HELP ROOM DESC ROOM DETAILS screen.");
            this.helpRoomDescRoomDetailsScreen.Pause();
            this.helpRoomDescRoomDetailsScreen.SetIsVisible(false);
            this.helpRoomDescRoomDetailsScreen.UnloadResources();
        } else if (this.prevGameState == GameStates.MAIN_GAME) {
            TyreDatGameUtils.wr("Hiding MAIN GAME screen.");
            this.mainGameScreen.Pause();
            this.mainGameScreen.SetIsVisible(false);
            this.mainGameScreen.UnloadResources();
        } else if (this.prevGameState == GameStates.SETTINGS) {
            TyreDatGameUtils.wr("Hiding SETTINGS screen.");
            this.settingsScreen.Pause();
            this.settingsScreen.SetIsVisible(false);
            this.settingsScreen.UnloadResources();
        }
        TyreDatGameUtils.wr("Switching Game State To: " + (Object)((Object)this.gameState));
        if (this.gameState == GameStates.BLANK) {
            TyreDatGameUtils.wr("Showing BLANK screen.");
        } else if (this.gameState == GameStates.LOADING) {
            TyreDatGameUtils.wr("Showing LOADING screen.");
            this.loadingScreen.LoadResources();
            this.loadingScreen.UnPause();
            this.loadingScreen.SetIsVisible(true);
            this.loadingScreen.StartDatLoad();
            this.currentScreen = this.loadingScreen;
        } else if (this.gameState == GameStates.SPLASH) {
            TyreDatGameUtils.wr("Showing SPLASH screen.");
            this.splashScreen.LoadResources();
            this.splashScreen.UnPause();
            this.splashScreen.SetIsVisible(true);
            this.splashScreen.StartDisplay();
            this.currentScreen = this.splashScreen;
        } else if (this.gameState == GameStates.MAIN_MENU) {
            TyreDatGameUtils.wr("Showing MAIN_MENU screen.");
            this.mainMenuScreen.LoadResources();
            this.mainMenuScreen.UnPause();
            this.mainMenuScreen.SetIsVisible(true);
            this.currentScreen = this.mainMenuScreen;
        } else if (this.gameState == GameStates.ABOUT) {
            TyreDatGameUtils.wr("Showing ABOUT screen.");
            this.aboutScreen.LoadResources();
            this.aboutScreen.UnPause();
            this.aboutScreen.SetIsVisible(true);
            this.currentScreen = this.aboutScreen;
        } else if (this.gameState == GameStates.HELP_MENU) {
            TyreDatGameUtils.wr("Showing HELP screen.");
            this.helpScreen.LoadResources();
            this.helpScreen.UnPause();
            this.helpScreen.SetIsVisible(true);
            this.currentScreen = this.helpScreen;
        } else if (this.gameState == GameStates.HELP_PROLOGUE) {
            TyreDatGameUtils.wr("Showing HELP PROLOGUE screen.");
            this.helpPrologueScreen.LoadResources();
            this.helpPrologueScreen.UnPause();
            this.helpPrologueScreen.SetIsVisible(true);
            this.currentScreen = this.helpPrologueScreen;
        } else if (this.gameState == GameStates.HELP_ITEM_DESC) {
            TyreDatGameUtils.wr("Showing HELP ITEM DESC screen.");
            this.helpItemDescScreen.LoadResources();
            this.helpItemDescScreen.UnPause();
            this.helpItemDescScreen.SetIsVisible(true);
            this.currentScreen = this.helpItemDescScreen;
        } else if (this.gameState == GameStates.HELP_ITEM_DESC_ITEM_TEXT) {
            TyreDatGameUtils.wr("Showing HELP ITEM DESC ITEM TEXT screen.");
            this.helpItemDescItemTextScreen.LoadResources();
            this.helpItemDescItemTextScreen.UnPause();
            this.helpItemDescItemTextScreen.SetIsVisible(true);
            this.currentScreen = this.helpItemDescItemTextScreen;
        } else if (this.gameState == GameStates.HELP_ENEMY_DESC) {
            TyreDatGameUtils.wr("Showing HELP ENEMY DESC screen.");
            this.helpEnemyDescScreen.LoadResources();
            this.helpEnemyDescScreen.UnPause();
            this.helpEnemyDescScreen.SetIsVisible(true);
            this.currentScreen = this.helpEnemyDescScreen;
        } else if (this.gameState == GameStates.HELP_GAME_PLAY_OVERWORLD) {
            TyreDatGameUtils.wr("Showing HELP GAME OVERWORLD screen.");
            this.helpGameOverworldScreen.LoadResources();
            this.helpGameOverworldScreen.UnPause();
            this.helpGameOverworldScreen.SetIsVisible(true);
            this.currentScreen = this.helpGameOverworldScreen;
        } else if (this.gameState == GameStates.HELP_GAME_PLAY_BATTLE_MODE) {
            TyreDatGameUtils.wr("Showing HELP GAME BATTLE MODE screen.");
            this.helpGameBattleModeScreen.LoadResources();
            this.helpGameBattleModeScreen.UnPause();
            this.helpGameBattleModeScreen.SetIsVisible(true);
            this.currentScreen = this.helpGameBattleModeScreen;
        } else if (this.gameState == GameStates.HELP_CHAR_DESC) {
            TyreDatGameUtils.wr("Showing HELP CHAR DESC screen.");
            this.helpCharDescScreen.LoadResources();
            this.helpCharDescScreen.UnPause();
            this.helpCharDescScreen.SetIsVisible(true);
            this.currentScreen = this.helpCharDescScreen;
        } else if (this.gameState == GameStates.HELP_QUEST_DESC) {
            TyreDatGameUtils.wr("Showing HELP QUEST DESC screen.");
            this.helpQuestDescScreen.LoadResources();
            this.helpQuestDescScreen.UnPause();
            this.helpQuestDescScreen.SetIsVisible(true);
            this.currentScreen = this.helpQuestDescScreen;
        } else if (this.gameState == GameStates.HELP_ROOM_DESC) {
            TyreDatGameUtils.wr("Showing HELP ROOM DESC screen.");
            this.helpRoomDescScreen.LoadResources();
            this.helpRoomDescScreen.UnPause();
            this.helpRoomDescScreen.SetIsVisible(true);
            this.currentScreen = this.helpRoomDescScreen;
        } else if (this.gameState == GameStates.HELP_ROOM_DESC_ROOM_DETAILS) {
            TyreDatGameUtils.wr("Showing HELP ROOM DESC ROOM DETAILS screen.");
            this.helpRoomDescRoomDetailsScreen.LoadResources();
            this.helpRoomDescRoomDetailsScreen.UnPause();
            this.helpRoomDescRoomDetailsScreen.SetIsVisible(true);
            this.currentScreen = this.helpRoomDescRoomDetailsScreen;
        } else if (this.gameState == GameStates.MAIN_GAME) {
            TyreDatGameUtils.wr("Showing MAIN GAME screen.");
            this.mainGameScreen.LoadResources();
            this.mainGameScreen.UnPause();
            this.mainGameScreen.SetIsVisible(true);
            this.currentScreen = this.mainGameScreen;
        } else if (this.gameState == GameStates.SETTINGS) {
            TyreDatGameUtils.wr("Showing SETTINGS screen.");
            this.settingsScreen.LoadResources();
            this.settingsScreen.UnPause();
            this.settingsScreen.SetIsVisible(true);
            this.currentScreen = this.settingsScreen;
        }
    }

    @Override
    public final void HandleGenericEvent(GenericEventMessage obj) {
        if (obj != null) {
            TyreDatGameUtils.wr("HandleGenericEvent " + (Object)((Object)obj.GetGameState()));
            if (obj.GetGameState() == GameStates.LOADING) {
                if (obj.GetId() == ScreenLoading.EVENT_LOAD_COMPLETE) {
                    this.SwitchGameState(GameStates.MAIN_MENU);
                }
            } else if (obj.GetGameState() == GameStates.SPLASH && obj.GetId() == ScreenSplash.EVENT_DISPLAY_COMPLETE) {
                this.SwitchGameState(GameStates.LOADING);
            }
        }
    }

    private Graphics2D GetBuffer() {
        if (this.graphics == null) {
            try {
                this.graphics = (Graphics2D)this.strategy.getDrawGraphics();
            }
            catch (IllegalStateException e) {
                return null;
            }
        }
        return this.graphics;
    }

    public final int GetWinWidth() {
        return this.winWidth;
    }

    public final int GetWinHeight() {
        return this.winHeight;
    }

    public final int GetX() {
        return this.myX;
    }

    public final int GetY() {
        return this.myY;
    }

    private boolean UpdateScreen() {
        this.graphics.dispose();
        this.graphics = null;
        try {
            this.strategy.show();
            Toolkit.getDefaultToolkit().sync();
            return !this.strategy.contentsLost();
        }
        catch (Exception e) {
            return true;
        }
    }

    public final void UpdateGame() {
        ++this.updateTick;
        this.prev = this.now;
        this.now = System.currentTimeMillis();
        if (this.currentScreen != null) {
            this.currentScreen.MmgUpdate(this.updateTick, this.now, this.now - this.prev);
        }
    }

    public final void RenderGame() {
        if (!PAUSE && !EXIT) {
            this.UpdateGame();
        }
        do {
            this.bg = this.GetBuffer();
            this.g2d = this.g = this.backgroundGraphics;
            if (this.currentScreen != null && !this.currentScreen.IsPaused() && this.currentScreen.IsReady()) {
                this.g.setColor(Color.DARK_GRAY);
                this.g.fillRect(0, 0, this.winWidth, this.winHeight);
                this.g.setColor(Color.WHITE);
                this.g.drawRect(MmgScreenData.GetGameLeft() - 1, MmgScreenData.GetGameTop() - 1, MmgScreenData.GetGameWidth() + 1, MmgScreenData.GetGameHeight() + 1);
                this.g.setColor(Color.BLACK);
                this.g.fillRect(MmgScreenData.GetGameLeft(), MmgScreenData.GetGameTop(), MmgScreenData.GetGameWidth(), MmgScreenData.GetGameHeight());
                this.p.SetGraphics((Graphics)this.g2d);
                this.p.SetAdvRenderHints();
                this.currentScreen.MmgDraw(this.p);
                if (TyreDatGameUtils.LOGGING) {
                    this.tmpF = this.g.getFont();
                    this.g.setFont(this.debugFont);
                    this.g.drawString(FPS, 15, 15);
                    this.g.drawString("Var1: " + VAR1, 15, 35);
                    this.g.drawString("Var2: " + VAR2, 15, 55);
                    this.g.setFont(this.tmpF);
                }
            }
            this.bg.drawImage((Image)this.background, this.myX, this.myY, null);
            this.bg.dispose();
        } while (!this.UpdateScreen());
    }

    static {
        GAME_TYPE = GameType.NEW_GAME;
    }

    public static enum GameType {
        NEW_GAME,
        CONTINUED_GAME;

    }

    public static enum GameStates {
        LOADING,
        BLANK,
        SPLASH,
        MAIN_MENU,
        ABOUT,
        HELP_MENU,
        HELP_PROLOGUE,
        HELP_ITEM_DESC,
        HELP_ENEMY_DESC,
        HELP_ITEM_DESC_ITEM_TEXT,
        HELP_GAME_PLAY_OVERWORLD,
        HELP_GAME_PLAY_BATTLE_MODE,
        HELP_CHAR_DESC,
        HELP_QUEST_DESC,
        HELP_ROOM_DESC,
        HELP_ROOM_DESC_ROOM_DETAILS,
        MAIN_GAME,
        SETTINGS;

    }
}

