/*
 * Decompiled with CFR 0.152.
 */
package com.middlemindgames.TyreGame;

import com.middlemindgames.TyreGame.GamePanel;
import com.middlemindgames.TyreGame.GenericEventHandler;
import com.middlemindgames.TyreGame.GenericEventMessage;
import com.middlemindgames.TyreGame.RunDatLoad;
import com.middlemindgames.TyreGame.TyreDatGame;
import com.middlemindgames.TyreGame.TyreDatGameUtils;
import com.middlemindgames.dat.LoadDatUpdateHandler;
import com.middlemindgames.dat.LoadDatUpdateMessage;
import java.nio.file.Files;
import java.nio.file.Paths;
import net.middlemind.MmgGameApiJava.MmgBase.MmgBmp;
import net.middlemind.MmgGameApiJava.MmgBase.MmgHelper;
import net.middlemind.MmgGameApiJava.MmgBase.MmgLoadingBar;
import net.middlemind.MmgGameApiJava.MmgBase.MmgLoadingScreen;
import net.middlemind.MmgGameApiJava.MmgBase.MmgObj;
import net.middlemind.MmgGameApiJava.MmgBase.MmgPen;
import net.middlemind.MmgGameApiJava.MmgBase.MmgScreenData;

public final class ScreenLoading
extends MmgLoadingScreen
implements LoadDatUpdateHandler {
    public static int EVENT_LOAD_COMPLETE = 0;
    private RunDatLoad datLoad;
    private MmgLoadingBar loadingBar;
    private final GamePanel.GameStates state;
    private GenericEventHandler handler;
    private final GamePanel owner;

    public ScreenLoading(MmgLoadingBar LoadingBar, float lBarOff, GamePanel.GameStates State2, GamePanel Owner) {
        super(LoadingBar, lBarOff);
        this.pause = false;
        this.ready = false;
        this.state = State2;
        this.owner = Owner;
    }

    public ScreenLoading(GamePanel.GameStates State2, GamePanel Owner) {
        this.pause = false;
        this.ready = false;
        this.state = State2;
        this.owner = Owner;
    }

    public final void SetGenericEventHandler(GenericEventHandler Handler) {
        this.handler = Handler;
    }

    public final void LoadResources() {
        this.SetHeight(MmgScreenData.GetGameHeight());
        this.SetWidth(MmgScreenData.GetGameWidth());
        this.SetPosition(MmgScreenData.GetPosition());
        MmgBmp tB = null;
        MmgBmp tB1 = null;
        MmgLoadingBar lb = null;
        int lbOffSet = 5;
        MmgPen p = new MmgPen();
        p.SetCacheOn(false);
        tB = TyreDatGameUtils.GetBasicBmp("../cfg/drawable/loading_background.jpg");
        if (tB != null) {
            this.SetCenteredBackground((MmgObj)tB);
        }
        tB = TyreDatGameUtils.GetBasicBmp("../cfg/drawable/loading_bar.png");
        tB1 = TyreDatGameUtils.GetBasicBmp("../cfg/drawable/blue_square.png");
        if (tB1 != null) {
            tB1.DRAW_MODE = MmgBmp.MmgBmpDrawMode.DRAW_BMP_FULL;
        }
        if (tB != null && tB1 != null) {
            lb = new MmgLoadingBar(tB1, tB);
            lb.SetMmgColor(null);
            lb.SetWidth(tB.GetWidth() - MmgHelper.ScaleValue((int)10));
            lb.SetHeight(tB.GetHeight() - MmgHelper.ScaleValue((int)12));
            lb.SetFillAmt(0.0f);
            lb.SetPaddingX(MmgHelper.ScaleValue((int)8));
            lb.SetPaddingY(MmgHelper.ScaleValue((int)4));
            lb.SetFillHeight(tB.GetHeight() - MmgHelper.ScaleValue((int)10));
            lb.SetFillWidth(tB.GetWidth() - MmgHelper.ScaleValue((int)12));
            this.loadingBar = lb;
            super.SetLoadingBar(lb, (float)lbOffSet);
        }
        this.ready = true;
    }

    public final void UnloadResources() {
        this.SetLoadingBar(null, 0.0f);
        this.SetBackground(null);
        this.ClearObjs();
        this.loadingBar = null;
        this.datLoad = null;
        this.ready = false;
    }

    public final GamePanel.GameStates GetGameState() {
        return this.state;
    }

    public final void MmgDraw(MmgPen p) {
        if (!this.pause && this.GetIsVisible()) {
            super.MmgDraw(p);
        }
    }

    private byte[] GetDatFileData() {
        byte[] ret = null;
        try {
            ret = Files.readAllBytes(Paths.get(TyreDatGame.DAT_FILE, new String[0]));
        }
        catch (Exception e) {
            TyreDatGameUtils.wrErr(e);
        }
        return ret;
    }

    public final void StartDatLoad() {
        boolean thin = false;
        byte[] data = this.GetDatFileData();
        if (data != null) {
            this.datLoad = new RunDatLoad(thin, data);
            this.datLoad.SetUpdateHandler(this);
            RunDatLoad r = this.datLoad;
            Thread t = new Thread(r);
            t.start();
        } else {
            TyreDatGameUtils.wr("No data found to load.");
        }
    }

    public final void StopDatLoad() {
        if (this.datLoad != null) {
            this.datLoad.StopDatLoad();
        }
    }

    public final void HandleUpdate(LoadDatUpdateMessage obj) {
        if (obj != null) {
            float prct = (float)obj.GetPos() / (float)obj.GetLen();
            if (this.loadingBar != null) {
                this.loadingBar.SetFillAmt(prct);
            }
            if (this.GetLoadComplete() && this.handler != null) {
                this.handler.HandleGenericEvent(new GenericEventMessage(EVENT_LOAD_COMPLETE, null, this.GetGameState()));
            }
            TyreDatGameUtils.wr("LoadingScreen POS: " + obj.GetPos() + " LEN: " + obj.GetLen() + " PRCT: " + prct + " LR: " + this.GetLoadResult() + " LC: " + this.GetLoadComplete());
        }
    }

    public final boolean GetLoadResult() {
        if (this.datLoad != null) {
            return this.datLoad.GetReadResult();
        }
        TyreDatGameUtils.wr("datLoad is NULL");
        return false;
    }

    public final boolean GetLoadComplete() {
        if (this.datLoad != null) {
            return this.datLoad.GetReadComplete();
        }
        TyreDatGameUtils.wr("datLoad is NULL");
        return false;
    }
}

