/*
 * Decompiled with CFR 0.152.
 */
package com.middlemindgames.TyreGame;

import com.middlemindgames.TyreGame.DatConstants;
import com.middlemindgames.TyreGame.DatConstantsEntry;
import com.middlemindgames.TyreGame.DatConstantsImporter;
import com.middlemindgames.TyreGame.GameSettings;
import com.middlemindgames.TyreGame.GameSettingsImporter;
import com.middlemindgames.TyreGame.MainFrame;
import com.middlemindgames.TyreGame.RunFrameRate;
import com.middlemindgames.TyreGame.TyreDatGameUtils;
import com.middlemindgames.TyreObjects.TyreLinkTable;
import com.middlemindgames.TyreObjects.TyreNpc;
import com.middlemindgames.TyreObjects.TyrePc;
import java.lang.reflect.Field;

public final class TyreDatGame {
    public static MainFrame mf;
    public static RunFrameRate fr;
    public static Thread t;
    public static int WIN_WIDTH;
    public static int WIN_HEIGHT;
    public static int PANEL_WIDTH;
    public static int PANEL_HEIGHT;
    public static long FPS;
    public static String DAT_MAP_FILE;
    public static String DAT_FILE;
    public static String ENGINE_CONFIG_FILE;

    public static String ArrayHasEntryLike(String v, String[] s) {
        int len = s.length;
        for (int i = 0; i < len; ++i) {
            if (!s[i].contains(v)) continue;
            return s[i];
        }
        return null;
    }

    public static void SetField(DatConstantsEntry ent, Field f) throws Exception {
        if (ent.type != null && ent.type.equals("int")) {
            f.setInt(null, Integer.parseInt(ent.val));
        } else if (ent.type != null && ent.type.equals("float")) {
            f.setFloat(null, Float.parseFloat(ent.val));
        } else if (ent.type != null && ent.type.equals("double")) {
            f.setDouble(null, Double.parseDouble(ent.val));
        } else if (ent.type != null && ent.type.equals("short")) {
            f.setShort(null, Short.parseShort(ent.val));
        } else if (ent.type != null && ent.type.equals("string")) {
            f.set(null, ent.val);
        } else if (ent.type != null && ent.type.equals("bool")) {
            f.setBoolean(null, Boolean.parseBoolean(ent.val));
        } else {
            f.setInt(null, Integer.parseInt(ent.val));
        }
    }

    public static final void main(String[] args) {
        Field f;
        String key;
        int i;
        DatConstantsEntry ent;
        String[] keys;
        int len;
        boolean r;
        Object dci;
        if (args != null && args.length > 0) {
            TyreDatGameUtils.wr("Found command line arguments!");
            String res = null;
            res = TyreDatGame.ArrayHasEntryLike("WIN_WIDTH=", args);
            if (res != null) {
                WIN_WIDTH = Integer.parseInt(res.split("=")[1]);
            }
            if ((res = TyreDatGame.ArrayHasEntryLike("WIN_HEIGHT=", args)) != null) {
                WIN_HEIGHT = Integer.parseInt(res.split("=")[1]);
            }
            if ((res = TyreDatGame.ArrayHasEntryLike("PANEL_WIDTH=", args)) != null) {
                PANEL_WIDTH = Integer.parseInt(res.split("=")[1]);
            }
            if ((res = TyreDatGame.ArrayHasEntryLike("PANEL_HEIGHT=", args)) != null) {
                PANEL_HEIGHT = Integer.parseInt(res.split("=")[1]);
            }
            if ((res = TyreDatGame.ArrayHasEntryLike("FPS=", args)) != null) {
                FPS = Integer.parseInt(res.split("=")[1]);
            }
            if ((res = TyreDatGame.ArrayHasEntryLike("DAT_MAP_FILE=", args)) != null) {
                DAT_MAP_FILE = res.split("=")[1];
            }
            if ((res = TyreDatGame.ArrayHasEntryLike("DAT_FILE=", args)) != null) {
                DAT_FILE = res.split("=")[1];
            }
            if ((res = TyreDatGame.ArrayHasEntryLike("ENGINE_CONFIG_FILE=", args)) != null) {
                ENGINE_CONFIG_FILE = res.split("=")[1];
            }
        }
        try {
            if (DAT_MAP_FILE != null && !DAT_MAP_FILE.equals("")) {
                dci = new DatConstantsImporter();
                r = ((DatConstantsImporter)dci).ImportDatConstants(DAT_MAP_FILE);
                System.out.println("Dat map load result: " + r);
                len = ((DatConstantsImporter)dci).GetValues().keySet().size();
                keys = ((DatConstantsImporter)dci).GetValues().keySet().toArray(new String[len]);
                ent = null;
                for (i = 0; i < len; ++i) {
                    try {
                        key = keys[i];
                        ent = ((DatConstantsImporter)dci).GetValues().get(key);
                        f = DatConstants.class.getField(ent.key);
                        if (f == null) continue;
                        System.out.println("Importing dat constants field: " + ent.key + " with value: " + ent.val + " with type: " + ent.type);
                        TyreDatGame.SetField(ent, f);
                        continue;
                    }
                    catch (Exception e) {
                        System.out.println("Ignoring dat constants field: " + ent.key + " with value: " + ent.val + " with type: " + ent.type);
                        TyreDatGameUtils.wrErr(e);
                    }
                }
            }
        }
        catch (Exception e) {
            TyreDatGameUtils.wrErr(e);
        }
        try {
            if (ENGINE_CONFIG_FILE != null && !ENGINE_CONFIG_FILE.equals("")) {
                dci = new GameSettingsImporter();
                r = ((GameSettingsImporter)dci).ImportGameSettings(ENGINE_CONFIG_FILE);
                System.out.println("Engine config load result: " + r);
                len = ((GameSettingsImporter)dci).GetValues().keySet().size();
                keys = ((GameSettingsImporter)dci).GetValues().keySet().toArray(new String[len]);
                ent = null;
                for (i = 0; i < len; ++i) {
                    try {
                        key = keys[i];
                        ent = ((GameSettingsImporter)dci).GetValues().get(key);
                        if (ent.from != null && ent.from.equals("GameSettings")) {
                            f = GameSettings.class.getField(ent.key);
                            if (f == null) continue;
                            System.out.println("Importing " + ent.from + " field: " + ent.key + " with value: " + ent.val + " with type: " + ent.type + " from: " + ent.from);
                            TyreDatGame.SetField(ent, f);
                            continue;
                        }
                        if (ent.from != null && ent.from.equals("TyreDatGameUtils")) {
                            f = TyreDatGameUtils.class.getField(ent.key);
                            if (f == null) continue;
                            System.out.println("Importing " + ent.from + " field: " + ent.key + " with value: " + ent.val + " with type: " + ent.type + " from: " + ent.from);
                            TyreDatGame.SetField(ent, f);
                            continue;
                        }
                        if (ent.from != null && ent.from.equals("TyreLinkTable")) {
                            f = TyreLinkTable.class.getField(ent.key);
                            if (f == null) continue;
                            System.out.println("Importing " + ent.from + " field: " + ent.key + " with value: " + ent.val + " with type: " + ent.type + " from: " + ent.from);
                            TyreDatGame.SetField(ent, f);
                            continue;
                        }
                        if (ent.from != null && ent.from.equals("TyrePc")) {
                            f = TyrePc.class.getField(ent.key);
                            if (f == null) continue;
                            System.out.println("Importing " + ent.from + " field: " + ent.key + " with value: " + ent.val + " with type: " + ent.type + " from: " + ent.from);
                            TyreDatGame.SetField(ent, f);
                            continue;
                        }
                        if (ent.from == null || !ent.from.equals("TyreNpc") || (f = TyreNpc.class.getField(ent.key)) == null) continue;
                        System.out.println("Importing " + ent.from + " field: " + ent.key + " with value: " + ent.val + " with type: " + ent.type + " from: " + ent.from);
                        TyreDatGame.SetField(ent, f);
                        continue;
                    }
                    catch (Exception e) {
                        System.out.println("Ignoring dat constants field: " + ent.key + " with value: " + ent.val + " with type: " + ent.type);
                        TyreDatGameUtils.wrErr(e);
                    }
                }
            }
        }
        catch (Exception e) {
            TyreDatGameUtils.wrErr(e);
        }
        TyreDatGameUtils.wr("TyreDatGame Window Width: " + WIN_WIDTH);
        TyreDatGameUtils.wr("TyreDatGame Window Height: " + WIN_HEIGHT);
        TyreDatGameUtils.wr("TyreDatGame Panel Width: " + PANEL_WIDTH);
        TyreDatGameUtils.wr("TyreDatGame Panel Height: " + PANEL_HEIGHT);
        mf = new MainFrame(WIN_WIDTH, WIN_HEIGHT, PANEL_WIDTH, PANEL_HEIGHT);
        fr = new RunFrameRate(mf, FPS);
        mf.setSize(WIN_WIDTH, WIN_HEIGHT);
        mf.setResizable(false);
        mf.setVisible(true);
        mf.setName(DatConstants.NAME);
        if (!DatConstants.DEVELOPMENT_MODE_ON) {
            mf.setTitle(DatConstants.TITLE);
        } else {
            mf.setTitle(DatConstants.TITLE + " - " + DatConstants.DEVELOPER_COMPANY + " (" + DatConstants.VERSION + ")");
        }
        mf.setDefaultCloseOperation(3);
        TyreDatGame.mf.pnlGame.PrepBuffers();
        t = new Thread(fr);
        t.start();
    }

    static {
        WIN_WIDTH = 858;
        WIN_HEIGHT = 600;
        PANEL_WIDTH = 854;
        PANEL_HEIGHT = 596;
        FPS = 16L;
        DAT_MAP_FILE = "../cfg/data_map/chapter2.xml";
        DAT_FILE = "../cfg/data/chapter2.dat";
        ENGINE_CONFIG_FILE = "../cfg/engine_config.xml";
    }
}

