/*
 * Decompiled with CFR 0.152.
 */
package com.middlemindgames.TyreObjects;

import com.middlemindgames.TyreGame.GameSettings;
import com.middlemindgames.TyreGame.TyreDatGameUtils;
import com.middlemindgames.dat.Enemy;
import com.middlemindgames.dat.ResourceContainer;
import net.middlemind.MmgGameApiJava.MmgBase.MmgBmp;
import net.middlemind.MmgGameApiJava.MmgBase.MmgObj;
import net.middlemind.MmgGameApiJava.MmgBase.MmgPen;

public final class TyreEnemy
extends MmgObj {
    private Enemy datObj;
    private boolean ready;
    private MmgBmp img;
    private String imgId;
    private boolean pause = false;

    public TyreEnemy(Enemy enm) {
        this.SetDatObj(enm);
        this.img = null;
        this.ready = false;
        this.LoadResources();
    }

    public TyreEnemy(Enemy enm, MmgBmp lImg) {
        this.SetDatObj(enm);
        this.img = lImg;
        this.ready = true;
    }

    public final int GetAiType() {
        return this.datObj.aiType;
    }

    public final int GetAttackPoints() {
        return this.datObj.ap;
    }

    public final int GetCoolDown() {
        return this.datObj.cooldown;
    }

    public final int GetDamage() {
        return this.datObj.damage;
    }

    public final int GetDefensePoints() {
        return this.datObj.dp;
    }

    public final int GetGoldCoinsMax() {
        return this.datObj.goldCoinsMax;
    }

    public final int GetHitTime() {
        return this.datObj.hitTime;
    }

    public final int GetHitPoints() {
        return this.datObj.hp;
    }

    public final int GetImageIndex() {
        return this.datObj.imageIndex;
    }

    public final int GetLevel() {
        return this.datObj.lv;
    }

    public final int GetMagicPoints() {
        return this.datObj.mp;
    }

    public final int GetMpUsage() {
        return this.datObj.mpUsage;
    }

    public final int GetShakeCount() {
        return this.datObj.shakeCount;
    }

    public final int GetSpeed() {
        return this.datObj.speed;
    }

    public final int GetStringIndex() {
        return this.datObj.stringIndex;
    }

    public final boolean GetIsDead() {
        return this.datObj.isDead;
    }

    public final boolean GetIsHit() {
        return this.datObj.isHit;
    }

    public final String GetNameString() {
        return ResourceContainer.strings[this.datObj.stringIndex];
    }

    public final boolean IsReady() {
        return this.ready;
    }

    public final void SetReady(boolean b) {
        this.ready = b;
    }

    public final Enemy GetDatObj() {
        return this.datObj;
    }

    public final void SetDatObj(Enemy itm) {
        this.datObj = itm;
        this.imgId = GameSettings.BMP_PREFIX + this.datObj.imageIndex;
    }

    public final String GetImageId() {
        return this.imgId;
    }

    public final MmgBmp GetImage() {
        return this.img;
    }

    public final void SetImage(MmgBmp lImg) {
        this.img = lImg;
    }

    public final void LoadResources() {
        this.img = TyreDatGameUtils.GetDatCachedBmp(this.datObj.imageIndex, this.imgId);
        this.ready = true;
    }

    public final void UnloadResources() {
        this.pause = true;
        this.img = null;
        this.imgId = null;
        this.ready = false;
    }

    public final TyreEnemy Clone() {
        TyreEnemy ret = new TyreEnemy(this.datObj);
        ret.SetPosition(this.GetPosition());
        ret.SetWidth(this.GetWidth());
        ret.SetHeight(this.GetHeight());
        return ret;
    }

    public final void MmgDraw(MmgPen p) {
        if (!this.pause && this.isVisible) {
            p.DrawBmp(this.img, this.GetPosition());
        }
    }

    public final int GetWidth() {
        return this.img.GetWidth();
    }

    public final void SetWidth(int i) {
        this.img.SetWidth(i);
    }

    public final int GetHeight() {
        return this.img.GetHeight();
    }

    public final void SetHeight(int i) {
        this.img.SetHeight(i);
    }
}

