/*
 * Decompiled with CFR 0.152.
 */
package com.middlemindgames.TyreObjects;

import com.middlemindgames.TyreGame.DatConstants;
import com.middlemindgames.TyreGame.GamePanel;
import com.middlemindgames.TyreGame.GameSettings;
import com.middlemindgames.TyreGame.TyreDatGameUtils;
import com.middlemindgames.TyreObjects.TyreSearchResult;
import com.middlemindgames.dat.ResourceContainer;
import java.io.File;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TyreInventory {
    private final Hashtable<String, Integer> inventory = new Hashtable(DEFAULT_SIZE);
    public static int DEFAULT_SIZE = 10;
    public static int MAX_ITEM_COUNT = 255;
    public static int MIN_ITEM_COUNT = 0;

    public TyreInventory() {
        this.ImportInventory(GameSettings.SAVE_DIR_INVENTORY);
    }

    public final boolean ImportInventory(String xmlDir) {
        File dir = new File(xmlDir);
        String[] files = dir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().contains(".xml");
            }
        });
        if (files == null || files.length == 0) {
            return false;
        }
        Arrays.sort(files, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                long i2;
                String ss1 = s1.replace(".xml", "");
                String ss2 = s2.replace(".xml", "");
                long i1 = Long.parseLong(ss1);
                if (i1 < (i2 = Long.parseLong(ss2))) {
                    return 1;
                }
                if (i1 > i2) {
                    return -1;
                }
                return 0;
            }
        });
        if (files == null || files.length == 0) {
            return false;
        }
        String file = xmlDir + files[0];
        TyreDatGameUtils.wr("Reading game inventory file: " + file);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new File(file));
            this.ClearInventory();
            Node nodeMain = document.getElementsByTagName("inventory").item(0);
            String version = nodeMain.getAttributes().getNamedItem("version").getNodeValue();
            NodeList nodeList = nodeMain.getChildNodes();
            if (version != null && version.equals("1.0")) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (node.getNodeType() != 1 || !node.getNodeName().equals("item")) continue;
                    Element elem = (Element)node;
                    String idStr = node.getAttributes().getNamedItem("id").getNodeValue();
                    String countStr = node.getAttributes().getNamedItem("count").getNodeValue();
                    TyreDatGameUtils.wr("Found inventory item with id: " + idStr + " Count: " + countStr);
                    this.inventory.put(idStr, Integer.parseInt(countStr));
                }
            } else {
                System.out.println("Currently only supports version 1.0 of inventory save files.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public final String ToString() {
        String xml = "";
        int len = this.inventory.keySet().size();
        String[] keys = this.inventory.keySet().toArray(new String[len]);
        for (int i = 0; i < len; ++i) {
            xml = xml + "Idx: " + i + " ItemId: " + keys[i] + " Count: " + this.inventory.get(keys[i]) + " Name: " + ResourceContainer.strings[ResourceContainer.items[Integer.parseInt((String)keys[i])].stringIndex] + "\n";
        }
        return xml;
    }

    public final boolean ExportInventory(String xmlDir) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddhhmmss");
        Date date = new Date();
        String now = sdf.format(date);
        String xml = "";
        String file = xmlDir + now + ".xml";
        try {
            xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
            xml = xml + "<inventory version=\"1.0\">\n";
            int len = this.inventory.keySet().size();
            String[] keys = this.inventory.keySet().toArray(new String[len]);
            for (int i = 0; i < len; ++i) {
                xml = xml + "<item id=\"" + keys[i] + "\" count=\"" + this.inventory.get(keys[i]) + "\" />\n";
            }
            xml = xml + "</inventory>\n";
            PrintWriter pw = new PrintWriter(file, "UTF-8");
            pw.write(xml);
            pw.flush();
            pw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public final int AddItems(TyreSearchResult[] sres) {
        int len = sres.length;
        int total = 0;
        for (int i = 0; i < len; ++i) {
            total += this.AddItem(sres[i].itemIndex, sres[i].count);
        }
        return total;
    }

    public final int AddItem(TyreSearchResult sres) {
        return this.AddItem(sres.itemIndex, sres.count);
    }

    public final int AddItem(int id, int count) {
        if (DatConstants.IsBadIndex(id)) {
            return -1;
        }
        if (id == DatConstants.SEARCH_ITEM_GOLD_LV1) {
            GamePanel.PC.GetState().goldAccumulated += count;
        }
        String idStr = id + "";
        Integer tmpInt = new Integer(0);
        if (this.inventory.containsKey(idStr)) {
            tmpInt = this.inventory.get(idStr);
            tmpInt = tmpInt + count;
        }
        if (tmpInt > MAX_ITEM_COUNT) {
            tmpInt = MAX_ITEM_COUNT;
        }
        this.inventory.put(idStr, tmpInt);
        return tmpInt;
    }

    public final int SubtractItems(TyreSearchResult[] sres) {
        int len = sres.length;
        int total = 0;
        for (int i = 0; i < len; ++i) {
            total += this.SubtractItem(sres[i].itemIndex, sres[i].count);
        }
        return total;
    }

    public final int SubtractItem(TyreSearchResult sres) {
        return this.SubtractItem(sres.itemIndex, sres.count);
    }

    public final int SubtractItem(int id, int count) {
        if (DatConstants.IsBadIndex(id)) {
            return -1;
        }
        String idStr = id + "";
        Integer tmpInt = new Integer(0);
        if (this.inventory.containsKey(idStr)) {
            tmpInt = this.inventory.get(idStr);
            tmpInt = tmpInt - count;
        }
        if (tmpInt <= MIN_ITEM_COUNT) {
            this.inventory.remove(idStr);
        } else {
            this.inventory.put(idStr, tmpInt);
        }
        return tmpInt;
    }

    public final boolean ClearItems(TyreSearchResult[] sres) {
        int len = sres.length;
        boolean total = true;
        for (int i = 0; i < len; ++i) {
            boolean tmp = this.ClearItem(sres[i].itemIndex);
            if (!total || tmp) continue;
            total = false;
        }
        return total;
    }

    public final boolean ClearItem(TyreSearchResult sres) {
        return this.ClearItem(sres.itemIndex);
    }

    public final boolean ClearItem(int id) {
        String idStr = id + "";
        if (this.inventory.containsKey(idStr)) {
            this.inventory.remove(idStr);
            return true;
        }
        return false;
    }

    public final boolean ClearInventory() {
        this.inventory.clear();
        return true;
    }

    public final TyreSearchResult[] GetItemCounts(TyreSearchResult[] sres) {
        int len = sres.length;
        for (int i = 0; i < len; ++i) {
            sres[i].count = this.GetItemCount(sres[i].itemIndex);
        }
        return sres;
    }

    public final int GetItemCount(TyreSearchResult sres) {
        return this.GetItemCount(sres.itemIndex);
    }

    public final int GetItemCount(int id) {
        String idStr = id + "";
        if (this.inventory.containsKey(idStr)) {
            return this.inventory.get(idStr);
        }
        return 0;
    }

    public final TyreSearchResult PerformGenericSearch() {
        int r = TyreDatGameUtils.GetRandomInt((DatConstants.SEARCH_ITEM_COUNT + 1) * 2);
        int target = 13;
        String msg = "";
        int id = 0;
        int cnt = 0;
        TyreDatGameUtils.wr("Searching for " + r);
        boolean found = false;
        switch (r) {
            case 0: {
                id = DatConstants.SEARCH_ITEM_HEALING_LV3;
                r = TyreDatGameUtils.GetRandomInt(DatConstants.SEARCH_ITEM_HEALING_LV3_ODDS + 1);
                if (r % target != 0) break;
                r = TyreDatGameUtils.GetRandomInt(DatConstants.SEARCH_ITEM_HEALING_LV3_MAX + 1);
                if (r == 0) {
                    ++r;
                }
                found = true;
                cnt = r;
                msg = "Found " + r + " restore potion";
                if (r <= 1) break;
                msg = msg + "s";
                break;
            }
            case 1: 
            case 11: {
                id = DatConstants.SEARCH_ITEM_HEALING_LV2;
                r = TyreDatGameUtils.GetRandomInt(DatConstants.SEARCH_ITEM_HEALING_LV2_ODDS + 1);
                if (r % target != 0) break;
                r = TyreDatGameUtils.GetRandomInt(DatConstants.SEARCH_ITEM_HEALING_LV2_MAX + 1);
                if (r == 0) {
                    ++r;
                }
                found = true;
                cnt = r;
                msg = "Found " + r + " healing salve";
                if (r <= 1) break;
                msg = msg + "s";
                break;
            }
            case 2: 
            case 12: 
            case 13: {
                id = DatConstants.SEARCH_ITEM_HEALING_LV1;
                r = TyreDatGameUtils.GetRandomInt(DatConstants.SEARCH_ITEM_HEALING_LV1_ODDS + 1);
                if (r % target != 0) break;
                r = TyreDatGameUtils.GetRandomInt(DatConstants.SEARCH_ITEM_HEALING_LV1_MAX + 1);
                if (r == 0) {
                    ++r;
                }
                found = true;
                cnt = r;
                msg = "Found " + r + " healing herb";
                if (r <= 1) break;
                msg = msg + "s";
                break;
            }
            case 3: 
            case 14: {
                id = DatConstants.SEARCH_ITEM_ANTIDOTE_LV2;
                r = TyreDatGameUtils.GetRandomInt(DatConstants.SEARCH_ITEM_ANTIDOTE_LV2_ODDS + 1);
                if (r % target != 0) break;
                r = TyreDatGameUtils.GetRandomInt(DatConstants.SEARCH_ITEM_ANTIDOTE_LV2_MAX + 1);
                if (r == 0) {
                    ++r;
                }
                found = true;
                cnt = r;
                msg = "Found " + r + " anti-poison herb";
                if (r <= 1) break;
                msg = msg + "s";
                break;
            }
            case 4: 
            case 15: {
                id = DatConstants.SEARCH_ITEM_ANTISLEEP_LV2;
                r = TyreDatGameUtils.GetRandomInt(DatConstants.SEARCH_ITEM_ANTISLEEP_LV2_ODDS + 1);
                if (r % target != 0) break;
                r = TyreDatGameUtils.GetRandomInt(DatConstants.SEARCH_ITEM_ANTISLEEP_LV2_MAX + 1);
                if (r == 0) {
                    ++r;
                }
                found = true;
                cnt = r;
                msg = "Found " + r + " anti-sleep herb";
                if (r <= 1) break;
                msg = msg + "s";
                break;
            }
            case 5: 
            case 16: 
            case 17: {
                id = DatConstants.SEARCH_ITEM_TORCH_LV1;
                r = TyreDatGameUtils.GetRandomInt(DatConstants.SEARCH_ITEM_TORCH_LV1_ODDS + 1);
                if (r % target != 0) break;
                r = TyreDatGameUtils.GetRandomInt(DatConstants.SEARCH_ITEM_TORCH_LV1_MAX + 1);
                if (r == 0) {
                    ++r;
                }
                found = true;
                cnt = r;
                msg = "Found " + r + " torch";
                if (r <= 1) break;
                msg = msg + "es";
                break;
            }
            case 6: 
            case 18: {
                id = DatConstants.SEARCH_ITEM_TORCH_LV2;
                r = TyreDatGameUtils.GetRandomInt(DatConstants.SEARCH_ITEM_TORCH_LV2_ODDS + 1);
                if (r % target != 0) break;
                r = TyreDatGameUtils.GetRandomInt(DatConstants.SEARCH_ITEM_TORCH_LV2_MAX + 1);
                if (r == 0) {
                    ++r;
                }
                found = true;
                cnt = r;
                msg = "Found " + r + " torch";
                if (r <= 1) break;
                msg = msg + "es";
                break;
            }
            case 7: {
                id = DatConstants.SEARCH_ITEM_TORCH_LV3;
                r = TyreDatGameUtils.GetRandomInt(DatConstants.SEARCH_ITEM_TORCH_LV3_ODDS + 1);
                if (r % target != 0) break;
                r = TyreDatGameUtils.GetRandomInt(DatConstants.SEARCH_ITEM_TORCH_LV3_MAX + 1);
                if (r == 0) {
                    ++r;
                }
                found = true;
                cnt = r;
                msg = "Found " + r + " torch";
                if (r <= 1) break;
                msg = msg + "es";
                break;
            }
            case 8: 
            case 19: 
            case 20: {
                id = DatConstants.SEARCH_ITEM_GOLD_LV1;
                r = TyreDatGameUtils.GetRandomInt(DatConstants.SEARCH_ITEM_GOLD_LV1_ODDS + 1);
                if (r % target != 0) break;
                r = TyreDatGameUtils.GetRandomInt(DatConstants.SEARCH_ITEM_GOLD_LV1_MAX + 1);
                if (r == 0) {
                    ++r;
                }
                found = true;
                cnt = r;
                msg = "Found " + r + " gold coin";
                if (r <= 1) break;
                msg = msg + "s";
                break;
            }
            case 9: 
            case 21: {
                id = DatConstants.SEARCH_ITEM_GOLD_LV2;
                r = TyreDatGameUtils.GetRandomInt(DatConstants.SEARCH_ITEM_GOLD_LV2_ODDS);
                if (r % target != 0) break;
                r = TyreDatGameUtils.GetRandomInt(DatConstants.SEARCH_ITEM_GOLD_LV2_MAX + 1);
                if (r == 0) {
                    ++r;
                }
                found = true;
                cnt = r;
                msg = "Found " + r + " gold coin";
                if (r <= 1) break;
                msg = msg + "s";
                break;
            }
            case 10: {
                id = DatConstants.SEARCH_ITEM_GOLD_LV3;
                r = TyreDatGameUtils.GetRandomInt(DatConstants.SEARCH_ITEM_GOLD_LV3_ODDS);
                if (r % target != 0) break;
                r = TyreDatGameUtils.GetRandomInt(DatConstants.SEARCH_ITEM_GOLD_LV3_MAX + 1);
                if (r == 0) {
                    ++r;
                }
                found = true;
                cnt = r;
                msg = "Found " + r + " gold coin";
                if (r <= 1) break;
                msg = msg + "s";
            }
        }
        if (found) {
            msg = msg + "!";
        }
        return new TyreSearchResult(id, cnt, msg, found);
    }
}

