/*
 * Decompiled with CFR 0.152.
 */
package com.middlemindgames.TyreObjects;

import com.middlemindgames.TyreGame.CollisionResult;
import com.middlemindgames.TyreGame.DatConstants;
import com.middlemindgames.TyreGame.GameSettings;
import com.middlemindgames.TyreGame.ScreenMainGame;
import com.middlemindgames.TyreGame.TyreDatGameUtils;
import com.middlemindgames.TyreObjects.TyreLinkTable;
import com.middlemindgames.dat.NpcData;
import com.middlemindgames.dat.ResourceContainer;
import java.util.Random;
import net.middlemind.MmgGameApiJava.MmgBase.MmgBmp;
import net.middlemind.MmgGameApiJava.MmgBase.MmgEvent;
import net.middlemind.MmgGameApiJava.MmgBase.MmgEventHandler;
import net.middlemind.MmgGameApiJava.MmgBase.MmgHelper;
import net.middlemind.MmgGameApiJava.MmgBase.MmgObj;
import net.middlemind.MmgGameApiJava.MmgBase.MmgPen;
import net.middlemind.MmgGameApiJava.MmgBase.MmgRect;
import net.middlemind.MmgGameApiJava.MmgBase.MmgSprite;
import net.middlemind.MmgGameApiJava.MmgBase.MmgVector2;

public final class TyreNpc
extends MmgObj
implements MmgEventHandler {
    private NpcData datObj;
    private boolean ready;
    private MmgSprite npc;
    private String[] npcImgIds;
    private int[] npcImgIdxs;
    private int currentDir;
    private int currentFoot;
    private int prevFoot;
    private int currentState;
    private NpcRenderMode npcRenderMode;
    private int msPerFrame;
    private boolean lret;
    public static int DEFAULT_MS_PER_FRAME_PACING = 500;
    public static int DEFAULT_MS_PER_FRAME_WALKING = 250;
    public static int VERT_OFFSET = MmgHelper.ScaleValue((int)DatConstants.NPC_OFFSET_Y);
    public static int SPEED = MmgHelper.ScaleValue((int)DatConstants.NPC_SPEED) + 1;
    private CollisionResult diffOverworld = null;
    private CollisionResult diffLocal = null;
    private TyreLinkTable npcRoomView = null;
    private boolean isTreeFolk = false;
    private boolean isPiggy = false;
    private Random wRand;
    private boolean inPaceTimeout;
    private long paceTimeoutStart;
    private final int PACE_TIMEOUT_DURATION_MS = 1500;
    private boolean inWalkTimeout;
    private long walkTimeoutStart;
    private final int WALK_TIMEOUT_DURATION_MS = 1500;
    private int nextMoveAi;
    private int nextDirAi;
    private final int[] badDirs;
    private boolean pause = false;

    public TyreNpc(NpcData npcd) {
        VERT_OFFSET = MmgHelper.ScaleValue((int)DatConstants.NPC_OFFSET_Y);
        SPEED = MmgHelper.ScaleValue((int)DatConstants.NPC_SPEED) + 1;
        this.badDirs = new int[4];
        this.inPaceTimeout = false;
        this.paceTimeoutStart = 0L;
        this.npcRenderMode = NpcRenderMode.PREVIEW;
        this.currentState = DatConstants.NPC_STATE_PACING;
        this.SetDatObj(npcd);
        this.npc = null;
        this.ready = false;
        this.LoadResources();
    }

    public TyreNpc(NpcData npcd, NpcRenderMode mode) {
        VERT_OFFSET = MmgHelper.ScaleValue((int)DatConstants.NPC_OFFSET_Y);
        SPEED = MmgHelper.ScaleValue((int)DatConstants.NPC_SPEED) + 1;
        this.badDirs = new int[4];
        this.inPaceTimeout = false;
        this.paceTimeoutStart = 0L;
        this.npcRenderMode = mode;
        this.currentState = DatConstants.NPC_STATE_PACING;
        this.SetDatObj(npcd);
        this.npc = null;
        this.ready = false;
        this.LoadResources();
    }

    public TyreNpc(NpcData npcd, NpcRenderMode mode, MmgSprite lSprite) {
        VERT_OFFSET = MmgHelper.ScaleValue((int)DatConstants.NPC_OFFSET_Y);
        SPEED = MmgHelper.ScaleValue((int)DatConstants.NPC_SPEED) + 1;
        this.badDirs = new int[4];
        this.inPaceTimeout = false;
        this.paceTimeoutStart = 0L;
        this.npcRenderMode = mode;
        this.currentState = DatConstants.NPC_STATE_PACING;
        this.SetDatObj(npcd);
        this.npc = lSprite;
        this.ready = true;
    }

    public final int GetBc() {
        return this.datObj.bc;
    }

    public final int GetBl() {
        return this.datObj.bl;
    }

    public final int GetBr() {
        return this.datObj.br;
    }

    public final int GetStartingDir() {
        return this.datObj.dir;
    }

    public final int GetFc() {
        return this.datObj.fc;
    }

    public final int GetFl() {
        return this.datObj.fl;
    }

    public final int GetFr() {
        return this.datObj.fr;
    }

    public final int GetNameStringIndex() {
        return this.datObj.stringIndex;
    }

    public final int GetDatHeight() {
        return this.datObj.height;
    }

    public final int GetLc() {
        return this.datObj.lc;
    }

    public final int GetLl() {
        return this.datObj.ll;
    }

    public final int GetLr() {
        return this.datObj.lr;
    }

    public final int GetNpcType() {
        return this.datObj.npcType;
    }

    public final int GetStartingPosX() {
        return this.datObj.posX;
    }

    public final int GetStartingPosY() {
        return this.datObj.posY;
    }

    public final int GetRc() {
        return this.datObj.rc;
    }

    public final int GetRl() {
        return this.datObj.rl;
    }

    public final int GetRr() {
        return this.datObj.rr;
    }

    public final int GetSpeed() {
        return this.datObj.speed;
    }

    public final String GetNameString() {
        return ResourceContainer.strings[this.datObj.stringIndex];
    }

    public final int GetToggle() {
        return this.datObj.toggle;
    }

    public final void SetToggle(int t) {
        this.datObj.toggle = t;
    }

    public final int GetWalkFreeze() {
        return this.datObj.walkFreeze;
    }

    public final int GetDatWidth() {
        return this.datObj.width;
    }

    public final boolean GetCanWalk() {
        return this.datObj.canWalk;
    }

    public final TyreLinkTable GetNpcRoomView() {
        return this.npcRoomView;
    }

    public final void SetNpcRoomView(TyreLinkTable t) {
        this.npcRoomView = t;
    }

    public final void MmgHandleEvent(MmgEvent e) {
        if (e.GetEventId() == 0 && this.currentState != DatConstants.NPC_STATE_STILL) {
            if (this.currentFoot == DatConstants.NPC_FEET_LEFT) {
                this.FootCenter();
                this.prevFoot = DatConstants.NPC_FEET_LEFT;
            } else if (this.currentFoot == DatConstants.NPC_FEET_RIGHT) {
                this.FootCenter();
                this.prevFoot = DatConstants.NPC_FEET_RIGHT;
            } else if (this.currentFoot == DatConstants.NPC_FEET_CENTER) {
                if (this.prevFoot == DatConstants.NPC_FEET_RIGHT) {
                    this.FootLeft();
                } else if (this.prevFoot == DatConstants.NPC_FEET_LEFT) {
                    this.FootRight();
                }
            }
        }
    }

    public final boolean IsTreeFolk() {
        return this.isTreeFolk;
    }

    public final void SetTreeFolk(boolean b) {
        this.isTreeFolk = b;
    }

    public final boolean IsPiggy() {
        return this.isPiggy;
    }

    public final void SetPiggy(boolean b) {
        this.isPiggy = b;
    }

    public final int GetCurrentDir() {
        return this.currentDir;
    }

    public final void SetCurrentDir(int currentDir) {
        this.currentDir = currentDir;
    }

    public final int GetCurrentFoot() {
        return this.currentFoot;
    }

    public final void SetCurrentFoot(int i) {
        this.currentFoot = i;
    }

    public final int GetCurrentState() {
        return this.currentState;
    }

    public final void SetCurrentState(int i) {
        this.currentState = i;
    }

    public final NpcRenderMode GetNpcRenderMode() {
        return this.npcRenderMode;
    }

    public final void SetNpcRenderMode(NpcRenderMode mode) {
        this.npcRenderMode = mode;
        if (this.npcRenderMode == NpcRenderMode.PREVIEW) {
            this.npc.SetOnFrameChange(null);
            this.npc.SetTimerOnly(false);
        } else {
            this.npc.SetOnFrameChange((MmgEventHandler)this);
            this.npc.SetTimerOnly(true);
        }
    }

    public final int GetMsPerFrame() {
        return this.msPerFrame;
    }

    public final void SetMsPerFrame(int i) {
        this.msPerFrame = i;
        this.npc.SetMsPerFrame((long)i);
    }

    public final MmgSprite GetNpc() {
        return this.npc;
    }

    public final void SetNpc(MmgSprite s) {
        this.npc = s;
    }

    private final void FootCenter() {
        if (this.currentDir == DatConstants.NPC_DIR_LEFT) {
            if (!this.npc.IsFrameNull(9)) {
                this.npc.SetFrameIdx(9);
                this.currentFoot = DatConstants.NPC_FEET_CENTER;
            }
        } else if (this.currentDir == DatConstants.NPC_DIR_RIGHT) {
            if (!this.npc.IsFrameNull(6)) {
                this.npc.SetFrameIdx(6);
                this.currentFoot = DatConstants.NPC_FEET_CENTER;
            }
        } else if (this.currentDir == DatConstants.NPC_DIR_FRONT) {
            if (!this.npc.IsFrameNull(0)) {
                this.npc.SetFrameIdx(0);
                this.currentFoot = DatConstants.NPC_FEET_CENTER;
            }
        } else if (this.currentDir == DatConstants.NPC_DIR_BACK && !this.npc.IsFrameNull(3)) {
            this.npc.SetFrameIdx(3);
            this.currentFoot = DatConstants.NPC_FEET_CENTER;
        }
    }

    private final void FootLeft() {
        if (this.currentDir == DatConstants.NPC_DIR_LEFT) {
            if (!this.npc.IsFrameNull(11)) {
                this.npc.SetFrameIdx(11);
                this.currentFoot = DatConstants.NPC_FEET_LEFT;
            }
        } else if (this.currentDir == DatConstants.NPC_DIR_RIGHT) {
            if (!this.npc.IsFrameNull(8)) {
                this.npc.SetFrameIdx(8);
                this.currentFoot = DatConstants.NPC_FEET_LEFT;
            }
        } else if (this.currentDir == DatConstants.NPC_DIR_FRONT) {
            if (!this.npc.IsFrameNull(2)) {
                this.npc.SetFrameIdx(2);
                this.currentFoot = DatConstants.NPC_FEET_LEFT;
            }
        } else if (this.currentDir == DatConstants.NPC_DIR_BACK && !this.npc.IsFrameNull(5)) {
            this.npc.SetFrameIdx(5);
            this.currentFoot = DatConstants.NPC_FEET_LEFT;
        }
    }

    private final void FootRight() {
        if (this.currentDir == DatConstants.NPC_DIR_LEFT) {
            if (!this.npc.IsFrameNull(10)) {
                this.npc.SetFrameIdx(10);
                this.currentFoot = DatConstants.NPC_FEET_RIGHT;
            }
        } else if (this.currentDir == DatConstants.NPC_DIR_RIGHT) {
            if (!this.npc.IsFrameNull(7)) {
                this.npc.SetFrameIdx(7);
                this.currentFoot = DatConstants.NPC_FEET_RIGHT;
            }
        } else if (this.currentDir == DatConstants.NPC_DIR_FRONT) {
            if (!this.npc.IsFrameNull(1)) {
                this.npc.SetFrameIdx(1);
                this.currentFoot = DatConstants.NPC_FEET_RIGHT;
            }
        } else if (this.currentDir == DatConstants.NPC_DIR_BACK && !this.npc.IsFrameNull(4)) {
            this.npc.SetFrameIdx(4);
            this.currentFoot = DatConstants.NPC_FEET_RIGHT;
        }
    }

    private void FaceLeft() {
        if (this.GetCanWalk() && !this.npc.IsFrameNull(9)) {
            this.npc.SetFrameIdx(9);
            this.currentDir = DatConstants.NPC_DIR_LEFT;
            this.currentFoot = DatConstants.NPC_FEET_CENTER;
        }
    }

    private void FaceRight() {
        if (this.GetCanWalk() && !this.npc.IsFrameNull(6)) {
            this.npc.SetFrameIdx(6);
            this.currentDir = DatConstants.NPC_DIR_RIGHT;
            this.currentFoot = DatConstants.NPC_FEET_CENTER;
        }
    }

    private void FaceFront() {
        if (this.GetCanWalk() && !this.npc.IsFrameNull(0)) {
            this.npc.SetFrameIdx(0);
            this.currentDir = DatConstants.NPC_DIR_FRONT;
            this.currentFoot = DatConstants.NPC_FEET_CENTER;
        }
    }

    private void FaceBack() {
        if (this.GetCanWalk() && !this.npc.IsFrameNull(4)) {
            this.npc.SetFrameIdx(4);
            this.currentDir = DatConstants.NPC_DIR_BACK;
            this.currentFoot = DatConstants.NPC_FEET_CENTER;
        }
    }

    public final boolean IsReady() {
        return this.ready;
    }

    public final void SetReady(boolean b) {
        this.ready = b;
    }

    public final NpcData GetDatObj() {
        return this.datObj;
    }

    public final void SetDatObj(NpcData npcd) {
        this.datObj = npcd;
        this.npcImgIds = new String[12];
        this.npcImgIds[0] = GameSettings.BMP_PREFIX + this.datObj.fc;
        this.npcImgIds[1] = GameSettings.BMP_PREFIX + this.datObj.fr;
        this.npcImgIds[2] = GameSettings.BMP_PREFIX + this.datObj.fl;
        this.npcImgIds[3] = GameSettings.BMP_PREFIX + this.datObj.bc;
        this.npcImgIds[4] = GameSettings.BMP_PREFIX + this.datObj.br;
        this.npcImgIds[5] = GameSettings.BMP_PREFIX + this.datObj.bl;
        this.npcImgIds[6] = GameSettings.BMP_PREFIX + this.datObj.rc;
        this.npcImgIds[7] = GameSettings.BMP_PREFIX + this.datObj.rr;
        this.npcImgIds[8] = GameSettings.BMP_PREFIX + this.datObj.rl;
        this.npcImgIds[9] = GameSettings.BMP_PREFIX + this.datObj.lc;
        this.npcImgIds[10] = GameSettings.BMP_PREFIX + this.datObj.lr;
        this.npcImgIds[11] = GameSettings.BMP_PREFIX + this.datObj.ll;
        this.npcImgIdxs = new int[12];
        this.npcImgIdxs[0] = this.datObj.fc;
        this.npcImgIdxs[1] = this.datObj.fr;
        this.npcImgIdxs[2] = this.datObj.fl;
        this.npcImgIdxs[3] = this.datObj.bc;
        this.npcImgIdxs[4] = this.datObj.br;
        this.npcImgIdxs[5] = this.datObj.bl;
        this.npcImgIdxs[6] = this.datObj.rc;
        this.npcImgIdxs[7] = this.datObj.rr;
        this.npcImgIdxs[8] = this.datObj.rl;
        this.npcImgIdxs[9] = this.datObj.lc;
        this.npcImgIdxs[10] = this.datObj.lr;
        this.npcImgIdxs[11] = this.datObj.ll;
    }

    public final int GetVertOffset() {
        return VERT_OFFSET;
    }

    public final MmgBmp GetCurrentFrame() {
        return this.npc.GetCurrentFrame();
    }

    public final MmgRect GetPseudoDepthCollisionRect() {
        return new MmgRect(new MmgVector2(this.GetX(), this.GetY() + this.GetHeight() - VERT_OFFSET), this.GetWidth(), VERT_OFFSET);
    }

    public final int GetPseudoDepthCollisionY() {
        return this.GetY() + this.GetHeight() - VERT_OFFSET;
    }

    public final MmgRect GetCollisionRect() {
        return new MmgRect(new MmgVector2(this.GetX(), this.GetY()), this.GetWidth(), this.GetHeight());
    }

    public final MmgRect GetPseudoDepthWalkCollisionRect() {
        if (this.currentState == DatConstants.NPC_STATE_WALKING) {
            if (this.currentDir == DatConstants.NPC_DIR_RIGHT) {
                return new MmgRect(new MmgVector2(this.GetX() + SPEED, this.GetY() + this.GetHeight() - VERT_OFFSET), this.GetWidth(), VERT_OFFSET);
            }
            if (this.currentDir == DatConstants.NPC_DIR_LEFT) {
                return new MmgRect(new MmgVector2(this.GetX() - SPEED, this.GetY() + this.GetHeight() - VERT_OFFSET), this.GetWidth(), VERT_OFFSET);
            }
            if (this.currentDir == DatConstants.NPC_DIR_FRONT) {
                return new MmgRect(new MmgVector2(this.GetX(), this.GetY() + this.GetHeight() - VERT_OFFSET + SPEED), this.GetWidth(), VERT_OFFSET);
            }
            if (this.currentDir == DatConstants.NPC_DIR_BACK) {
                return new MmgRect(new MmgVector2(this.GetX(), this.GetY() + this.GetHeight() - VERT_OFFSET - SPEED), this.GetWidth(), VERT_OFFSET);
            }
            return this.GetPseudoDepthCollisionRect();
        }
        return this.GetPseudoDepthCollisionRect();
    }

    public final MmgRect GetProjectedPseudoDepthWalkCollisionRect(int dir) {
        if (dir == DatConstants.NPC_DIR_RIGHT) {
            return new MmgRect(new MmgVector2(this.GetX() + SPEED, this.GetY() + this.GetHeight() - VERT_OFFSET), this.GetWidth(), VERT_OFFSET);
        }
        if (dir == DatConstants.NPC_DIR_LEFT) {
            return new MmgRect(new MmgVector2(this.GetX() - SPEED, this.GetY() + this.GetHeight() - VERT_OFFSET), this.GetWidth(), VERT_OFFSET);
        }
        if (dir == DatConstants.NPC_DIR_FRONT) {
            return new MmgRect(new MmgVector2(this.GetX(), this.GetY() + this.GetHeight() - VERT_OFFSET + SPEED), this.GetWidth(), VERT_OFFSET);
        }
        if (dir == DatConstants.NPC_DIR_BACK) {
            return new MmgRect(new MmgVector2(this.GetX(), this.GetY() + this.GetHeight() - VERT_OFFSET - SPEED), this.GetWidth(), VERT_OFFSET);
        }
        return this.GetPseudoDepthCollisionRect();
    }

    public final MmgRect GetProjectedWalkCollisionRect(int dir) {
        if (dir == DatConstants.NPC_DIR_RIGHT) {
            return new MmgRect(new MmgVector2(this.GetX() + SPEED, this.GetY()), this.GetWidth(), this.GetHeight());
        }
        if (dir == DatConstants.NPC_DIR_LEFT) {
            return new MmgRect(new MmgVector2(this.GetX() - SPEED, this.GetY()), this.GetWidth(), this.GetHeight());
        }
        if (dir == DatConstants.NPC_DIR_FRONT) {
            return new MmgRect(new MmgVector2(this.GetX(), this.GetY() + SPEED), this.GetWidth(), this.GetHeight());
        }
        if (dir == DatConstants.NPC_DIR_BACK) {
            return new MmgRect(new MmgVector2(this.GetX(), this.GetY() - SPEED), this.GetWidth(), this.GetHeight());
        }
        return this.GetCollisionRect();
    }

    public final MmgRect GetWalkCollisionRect() {
        if (this.currentState == DatConstants.NPC_STATE_WALKING) {
            if (this.currentDir == DatConstants.NPC_DIR_RIGHT) {
                return new MmgRect(new MmgVector2(this.GetX() + SPEED, this.GetY()), this.GetWidth(), this.GetHeight());
            }
            if (this.currentDir == DatConstants.NPC_DIR_LEFT) {
                return new MmgRect(new MmgVector2(this.GetX() - SPEED, this.GetY()), this.GetWidth(), this.GetHeight());
            }
            if (this.currentDir == DatConstants.NPC_DIR_FRONT) {
                return new MmgRect(new MmgVector2(this.GetX(), this.GetY() + SPEED), this.GetWidth(), this.GetHeight());
            }
            if (this.currentDir == DatConstants.NPC_DIR_BACK) {
                return new MmgRect(new MmgVector2(this.GetX(), this.GetY() - SPEED), this.GetWidth(), this.GetHeight());
            }
            return this.GetCollisionRect();
        }
        return this.GetCollisionRect();
    }

    public final int GetPseudoDepthWalkCollisionY() {
        if (this.currentState == DatConstants.NPC_STATE_WALKING) {
            if (this.currentDir == DatConstants.NPC_DIR_RIGHT) {
                return this.GetY() + this.GetHeight() - VERT_OFFSET;
            }
            if (this.currentDir == DatConstants.NPC_DIR_LEFT) {
                return this.GetY() + this.GetHeight() - VERT_OFFSET;
            }
            if (this.currentDir == DatConstants.NPC_DIR_FRONT) {
                return this.GetY() + this.GetHeight() - VERT_OFFSET + SPEED;
            }
            if (this.currentDir == DatConstants.NPC_DIR_BACK) {
                return this.GetY() + this.GetHeight() - VERT_OFFSET - SPEED;
            }
            return this.GetPseudoDepthCollisionY();
        }
        return this.GetPseudoDepthCollisionY();
    }

    public final void LoadResources() {
        int len = this.npcImgIds.length;
        MmgBmp[] frames = new MmgBmp[len];
        for (int i = 0; i < len; ++i) {
            if (DatConstants.IsBadIndex(this.npcImgIdxs[i])) {
                TyreDatGameUtils.wr("Missing frame: " + i);
                continue;
            }
            frames[i] = TyreDatGameUtils.GetDatCachedBmp(this.npcImgIdxs[i], this.npcImgIds[i]);
        }
        Random rand = new Random();
        rand.setSeed(System.nanoTime());
        int offset = rand.nextInt(50 + DEFAULT_MS_PER_FRAME_PACING * 2);
        this.wRand = rand;
        this.npc = new MmgSprite(frames);
        this.npc.SetSimpleRendering(true);
        TyreDatGameUtils.wr("Render Mode: " + (Object)((Object)this.npcRenderMode));
        if (this.npcRenderMode == NpcRenderMode.PREVIEW) {
            this.npc.SetOnFrameChange(null);
            this.npc.SetTimerOnly(false);
        } else {
            this.npc.SetOnFrameChange((MmgEventHandler)this);
            this.npc.SetTimerOnly(true);
        }
        this.npc.SetPosition(this.GetPosition());
        this.npc.SetMsPerFrame((long)(DEFAULT_MS_PER_FRAME_PACING + offset));
        if (DatConstants.NPC_DIR_FRONT == this.GetStartingDir()) {
            this.npc.SetFrameIdx(0);
            if (!this.GetCanWalk()) {
                this.npc.SetFrameStart(0);
                this.npc.SetFrameStop(2);
            }
        } else if (DatConstants.NPC_DIR_LEFT == this.GetStartingDir()) {
            this.npc.SetFrameIdx(9);
            if (!this.GetCanWalk()) {
                this.npc.SetFrameStart(9);
                this.npc.SetFrameStop(11);
            }
        } else if (DatConstants.NPC_DIR_RIGHT == this.GetStartingDir()) {
            this.npc.SetFrameIdx(6);
            if (!this.GetCanWalk()) {
                this.npc.SetFrameStart(6);
                this.npc.SetFrameStop(8);
            }
        } else if (DatConstants.NPC_DIR_BACK == this.GetStartingDir()) {
            this.npc.SetFrameIdx(3);
            if (!this.GetCanWalk()) {
                this.npc.SetFrameStart(3);
                this.npc.SetFrameStop(5);
            }
        }
        this.ready = true;
    }

    public final void UnloadResources() {
        this.pause = true;
        this.npc = null;
        this.npcImgIds = null;
        this.npcImgIdxs = null;
        this.wRand = null;
        this.ready = false;
    }

    public final void SetPosition(MmgVector2 pos) {
        super.SetPosition(pos);
        this.npc.SetPosition(pos);
    }

    public final MmgVector2 GetPosition() {
        return super.GetPosition();
    }

    public final TyreNpc Clone() {
        TyreNpc ret = new TyreNpc(this.datObj, this.GetNpcRenderMode());
        ret.SetCurrentDir(this.GetCurrentDir());
        ret.SetCurrentFoot(this.GetCurrentFoot());
        ret.SetCurrentState(this.GetCurrentState());
        ret.SetMsPerFrame(this.GetMsPerFrame());
        ret.SetPosition(this.GetPosition());
        ret.GetNpc().SetFrameIdx(this.npc.GetFrameIdx());
        ret.GetNpc().SetFrameStart(this.npc.GetFrameStart());
        ret.GetNpc().SetFrameStop(this.npc.GetFrameStop());
        ret.SetWidth(this.GetWidth());
        ret.SetHeight(this.GetHeight());
        return ret;
    }

    public final void MmgDraw(MmgPen p) {
        if (!this.pause && this.isVisible) {
            this.npc.MmgDraw(p);
        }
    }

    public CollisionResult CollidesWithRoomEdges(MmgRect r) {
        if (r.GetLeft() > 0 && r.GetRight() < ScreenMainGame.SCALED_ROOM_WIDTH && r.GetTop() > 0 && r.GetBottom() < ScreenMainGame.SCALED_ROOM_HEIGHT) {
            return new CollisionResult(true);
        }
        return new CollisionResult(false);
    }

    public final boolean MmgUpdate(int updateTick, long currentTimeMs, long msSinceLastFrame) {
        this.lret = false;
        if (this.GetCanWalk() && this.currentState != DatConstants.NPC_STATE_STILL) {
            if (this.GetNpcRenderMode() != NpcRenderMode.PREVIEW) {
                if (this.npc.MmgUpdate(updateTick, currentTimeMs, msSinceLastFrame)) {
                    this.lret = true;
                }
                if (this.inPaceTimeout) {
                    if (currentTimeMs - this.paceTimeoutStart >= 1500L) {
                        this.inPaceTimeout = false;
                    }
                } else if (this.inWalkTimeout) {
                    if (currentTimeMs - this.walkTimeoutStart >= 1500L) {
                        this.inWalkTimeout = false;
                        this.currentState = DatConstants.NPC_STATE_PACING;
                    } else {
                        this.diffLocal = this.npcRoomView != null ? this.npcRoomView.CollidesWithForNpc(this.GetPseudoDepthWalkCollisionRect(), this) : new CollisionResult();
                        this.diffOverworld = this.diffLocal.CanWalk() ? this.CollidesWithRoomEdges(this.GetWalkCollisionRect()) : new CollisionResult();
                        if (this.diffOverworld.CanWalk()) {
                            if (this.diffLocal.CanWalk()) {
                                this.badDirs[0] = 0;
                                this.badDirs[1] = 0;
                                this.badDirs[2] = 0;
                                this.badDirs[3] = 0;
                                if (this.currentDir == DatConstants.NPC_DIR_LEFT) {
                                    this.SetX(this.GetX() - SPEED);
                                    this.lret = true;
                                } else if (this.currentDir == DatConstants.NPC_DIR_RIGHT) {
                                    this.SetX(this.GetX() + SPEED);
                                    this.lret = true;
                                } else if (this.currentDir == DatConstants.NPC_DIR_FRONT) {
                                    this.SetY(this.GetY() + SPEED);
                                    this.lret = true;
                                } else if (this.currentDir == DatConstants.NPC_DIR_BACK) {
                                    this.SetY(this.GetY() - SPEED);
                                    this.lret = true;
                                }
                            } else {
                                this.badDirs[this.currentDir] = 1;
                                if (this.currentDir == DatConstants.NPC_DIR_LEFT) {
                                    if (this.diffLocal.GetOffset().GetX() >= -SPEED && this.diffLocal.GetOffset().GetX() <= SPEED) {
                                        this.SetX(this.GetX() - (SPEED + this.diffLocal.GetOffset().GetX()) + 2);
                                        this.lret = true;
                                    }
                                } else if (this.currentDir == DatConstants.NPC_DIR_RIGHT) {
                                    if (this.diffLocal.GetOffset().GetX() >= -SPEED && this.diffLocal.GetOffset().GetX() <= SPEED) {
                                        this.SetX(this.GetX() + (SPEED - this.diffLocal.GetOffset().GetX()) - 2);
                                        this.lret = true;
                                    }
                                } else if (this.currentDir == DatConstants.NPC_DIR_FRONT) {
                                    if (this.diffLocal.GetOffset().GetY() >= -SPEED && this.diffLocal.GetOffset().GetY() <= SPEED) {
                                        this.SetY(this.GetY() + (SPEED - this.diffLocal.GetOffset().GetY()) - 2);
                                        this.lret = true;
                                    }
                                } else if (this.currentDir == DatConstants.NPC_DIR_BACK && this.diffLocal.GetOffset().GetY() >= -SPEED && this.diffLocal.GetOffset().GetY() <= SPEED) {
                                    this.SetY(this.GetY() - (SPEED + this.diffLocal.GetOffset().GetY()) + 2);
                                    this.lret = true;
                                }
                                this.inWalkTimeout = false;
                            }
                        } else {
                            this.badDirs[this.currentDir] = 1;
                            this.inWalkTimeout = false;
                            this.currentState = DatConstants.NPC_STATE_PACING;
                        }
                    }
                } else if (!this.inPaceTimeout && !this.inWalkTimeout) {
                    this.nextMoveAi = this.wRand.nextInt(10);
                    if (this.nextMoveAi >= 0 && this.nextMoveAi <= 3) {
                        this.inPaceTimeout = true;
                        this.paceTimeoutStart = currentTimeMs;
                        this.currentState = DatConstants.NPC_STATE_PACING;
                    } else if (this.nextMoveAi >= 4 && this.nextMoveAi <= 6) {
                        this.nextDirAi = this.wRand.nextInt(4);
                        if (this.badDirs[this.nextDirAi] == 1) {
                            this.nextDirAi = this.wRand.nextInt(4);
                            if (this.badDirs[this.nextDirAi] == 1) {
                                this.nextDirAi = this.wRand.nextInt(4);
                            }
                        }
                        if (this.nextDirAi == DatConstants.NPC_DIR_LEFT) {
                            this.FaceLeft();
                        } else if (this.nextDirAi == DatConstants.NPC_DIR_RIGHT) {
                            this.FaceRight();
                        } else if (this.nextDirAi == DatConstants.NPC_DIR_BACK) {
                            this.FaceBack();
                        } else if (this.nextDirAi == DatConstants.NPC_DIR_FRONT) {
                            this.FaceFront();
                        }
                        this.inPaceTimeout = true;
                        this.paceTimeoutStart = currentTimeMs;
                        this.currentState = DatConstants.NPC_STATE_PACING;
                    } else if (this.nextMoveAi >= 7 && this.nextMoveAi <= 9) {
                        this.inWalkTimeout = true;
                        this.walkTimeoutStart = currentTimeMs;
                        this.currentState = DatConstants.NPC_STATE_WALKING;
                    }
                }
            }
        } else if (this.GetNpcRenderMode() != NpcRenderMode.PREVIEW && this.npc.MmgUpdate(updateTick, currentTimeMs, msSinceLastFrame)) {
            this.lret = true;
        }
        return this.lret;
    }

    public final int GetWidth() {
        return this.npc.GetWidth();
    }

    public final void SetWidth(int i) {
        this.npc.SetWidth(i);
    }

    public final int GetHeight() {
        return this.npc.GetHeight();
    }

    public final void SetHeight(int i) {
        this.npc.SetHeight(i);
    }

    public static enum NpcRenderMode {
        PREVIEW,
        GAME;

    }
}

