/*
 * Decompiled with CFR 0.152.
 */
package com.middlemindgames.TyreObjects;

import com.middlemindgames.TyreGame.CollisionResult;
import com.middlemindgames.TyreGame.ControlBgroundStory;
import com.middlemindgames.TyreGame.DatConstants;
import com.middlemindgames.TyreGame.GamePanel;
import com.middlemindgames.TyreGame.ScreenMainGame;
import com.middlemindgames.TyreGame.TyreDatGameUtils;
import com.middlemindgames.TyreObjects.TyreItem;
import com.middlemindgames.TyreObjects.TyreObject;
import com.middlemindgames.TyreObjects.TyreSearchResult;
import com.middlemindgames.dat.ResourceContainer;
import com.middlemindgames.dat.Search;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import net.middlemind.MmgGameApiJava.MmgBase.Mmg9Slice;
import net.middlemind.MmgGameApiJava.MmgBase.MmgBmp;
import net.middlemind.MmgGameApiJava.MmgBase.MmgBmpScaler;
import net.middlemind.MmgGameApiJava.MmgBase.MmgColor;
import net.middlemind.MmgGameApiJava.MmgBase.MmgEventHandler;
import net.middlemind.MmgGameApiJava.MmgBase.MmgFont;
import net.middlemind.MmgGameApiJava.MmgBase.MmgFontData;
import net.middlemind.MmgGameApiJava.MmgBase.MmgHelper;
import net.middlemind.MmgGameApiJava.MmgBase.MmgObj;
import net.middlemind.MmgGameApiJava.MmgBase.MmgPen;
import net.middlemind.MmgGameApiJava.MmgBase.MmgPositionTween;
import net.middlemind.MmgGameApiJava.MmgBase.MmgScreenData;
import net.middlemind.MmgGameApiJava.MmgBase.MmgVector2;

public final class TyreOverworldViewActionSearch
extends MmgObj {
    private boolean ready;
    private boolean dirty = false;
    private boolean pause = false;
    private boolean lret;
    private MmgBmp img;
    private MmgBmp bground;
    private Mmg9Slice menuBground;
    private MmgVector2 startPos;
    private MmgVector2 finishPos;
    private MmgPositionTween posTween;
    private ControlBgroundStory text;
    private final int paddingX;
    private final int paddingY;
    private final int offsetX;
    private final int offsetY;
    private BufferedImage bg;
    private Graphics2D bgGraphics;
    private MmgPen p;
    private ScreenMainGame mainGameScreen;
    private final int lp;
    public static int SEARCH_COUNT_RECENT = 0;
    public static int SEARCH_COUNT_TOTAL = 0;
    public static int[] IRITATION_LEVELS = new int[]{10, 15, 20};
    public static boolean TEST_MODE_ON = true;
    public static int TEST_MODE_SEARCH_INDEX = 0;
    private String msg;
    private CollisionResult res;
    private TyreObject obj;
    private TyreSearchResult sres;
    private boolean found;
    private boolean foundSearch;
    private boolean foundItem;
    private TyreItem tItm;
    private Search srch;

    public TyreOverworldViewActionSearch(MmgBmp Bground, ScreenMainGame mgs, int PaddingX, int PaddingY, int OffsetX, int OffsetY) {
        this.bground = Bground;
        this.paddingX = PaddingX;
        this.paddingY = PaddingY;
        this.offsetX = OffsetX;
        this.offsetY = OffsetY;
        this.lp = MmgHelper.ScaleValue((int)10);
        this.mainGameScreen = mgs;
        this.ready = false;
        SEARCH_COUNT_RECENT = 0;
        this.LoadResources();
    }

    public void SetFinishEventId(int i) {
        if (this.posTween != null) {
            this.posTween.SetFinishEventId(i);
        }
    }

    public void SetStartEventId(int i) {
        if (this.posTween != null) {
            this.posTween.SetStartEventId(i);
        }
    }

    public void SetEventHandler(MmgEventHandler h) {
        if (this.posTween != null) {
            this.posTween.SetOnReachFinish(h);
            this.posTween.SetOnReachStart(h);
        }
    }

    public final boolean IsReady() {
        return this.ready;
    }

    public final void SetReady(boolean b) {
        this.ready = b;
    }

    public final boolean IsPaused() {
        return this.pause;
    }

    public final void SetPaused(boolean b) {
        this.pause = b;
    }

    public final boolean IsDirty() {
        return this.dirty;
    }

    public final void SetDirty(boolean b) {
        this.dirty = b;
    }

    public final MmgBmp GetImage() {
        return this.img;
    }

    public final void SetImage(MmgBmp lImg) {
        this.img = lImg;
    }

    private void PrepBuffers(int w, int h) {
        this.bg = this.create(w, h, false);
        this.bgGraphics = (Graphics2D)this.bg.getGraphics();
    }

    private BufferedImage create(int width, int height, boolean alpha) {
        return MmgBmpScaler.GRAPHICS_CONFIG.createCompatibleImage(width, height, alpha ? 3 : 1);
    }

    public final void LoadResources() {
        this.pause = true;
        int menuWidth = this.paddingX + MmgHelper.ScaleValue((int)DatConstants.DIALOG_SEARCH_WIDTH) + this.paddingX;
        int menuHeight = this.paddingY + MmgHelper.ScaleValue((int)DatConstants.DIALOG_SEARCH_HEIGHT) + this.paddingY;
        int totalWidth = this.offsetX + menuWidth + this.offsetX;
        int totalHeight = this.offsetY + menuHeight + this.offsetY;
        int padding = MmgHelper.ScaleValue((int)20);
        this.menuBground = new Mmg9Slice(16, this.bground, totalWidth, totalHeight);
        this.menuBground.SetPosition(MmgVector2.GetOriginVec());
        this.menuBground.SetWidth(totalWidth);
        this.menuBground.SetHeight(totalHeight);
        MmgHelper.CenterHorAndVert((MmgObj)this.menuBground);
        this.startPos = new MmgVector2(this.menuBground.GetPosition().GetX(), MmgScreenData.GetGameTop() - totalHeight - MmgHelper.ScaleValue((int)10));
        this.finishPos = this.menuBground.GetPosition().Clone();
        this.SetPosition(this.startPos);
        this.SetWidth(totalWidth);
        this.SetHeight(totalHeight);
        this.menuBground.SetPosition(MmgVector2.GetOriginVec());
        TyreDatGameUtils.wr("OverworldViewActionSearch: " + totalWidth + "x" + totalHeight);
        if (this.bgGraphics == null) {
            this.PrepBuffers(this.w, this.h);
        }
        this.p = new MmgPen();
        this.p.SetGraphics((Graphics)this.bgGraphics);
        this.p.SetAdvRenderHints();
        this.img = new MmgBmp((Image)this.bg);
        TyreDatGameUtils.wr("Found start pos: " + this.startPos.ToString());
        TyreDatGameUtils.wr("Found end pos: " + this.finishPos.ToString());
        this.posTween = new MmgPositionTween((MmgObj)this, DatConstants.ANIMATION_TIME_MS_OVERWORLD_SEARCH, this.startPos, this.finishPos);
        this.SetPosition(this.startPos);
        this.SetWidth(totalWidth);
        this.SetHeight(totalHeight);
        this.text = new ControlBgroundStory();
        this.text.SetLineHeight(MmgFontData.GetTargetPixelHeightScaled() + MmgHelper.ScaleValue((int)2));
        this.text.SetHeight(totalHeight - padding);
        this.text.SetWidth(totalWidth - padding);
        this.text.SetPaddingX(MmgHelper.ScaleValue((int)this.text.GetPaddingX()));
        this.text.SetPaddingY(MmgHelper.ScaleValue((int)this.text.GetPaddingY()));
        this.text.SetPosition(this.startPos);
        this.text.SetColor(MmgColor.GetWhite());
        this.ready = true;
        this.pause = false;
    }

    public final void DrawScreen() {
        this.pause = true;
        this.menuBground.MmgDraw(this.p);
        this.msg = "I couldn't find anything.";
        this.res = null;
        this.obj = null;
        this.sres = null;
        this.found = false;
        this.foundSearch = false;
        this.foundItem = false;
        this.tItm = null;
        this.srch = null;
        int icnt = 0;
        int sidx = 0;
        if (this.mainGameScreen.GetOverworldView().GetPcRoomView().HasSearch() || TEST_MODE_ON) {
            this.res = this.mainGameScreen.GetOverworldView().GetPcRoomView().CollidesWithForSearch(GamePanel.PC.GetSearchCollisionRect());
            if (this.res != null && !this.res.CanWalk() || TEST_MODE_ON) {
                TyreDatGameUtils.wr("AAA");
                this.found = true;
                this.foundSearch = true;
                this.obj = this.res.GetCollidedWith();
                if (this.obj != null || TEST_MODE_ON) {
                    TyreDatGameUtils.wr("BBB");
                    this.msg = "You've found something!";
                    if (TEST_MODE_ON) {
                        this.srch = ResourceContainer.searches[TEST_MODE_SEARCH_INDEX];
                        sidx = TEST_MODE_SEARCH_INDEX;
                    } else {
                        this.srch = ResourceContainer.searches[this.obj.GetSearchItem()];
                        sidx = this.obj.GetSearchItem();
                    }
                    icnt = TyreObject.GetSearchItemCount(this.srch);
                    GamePanel.PC.GetInventory().AddItem(this.srch.item1, this.srch.quantity1);
                    GamePanel.PC.GetInventory().AddItem(this.srch.item2, this.srch.quantity2);
                    GamePanel.PC.GetInventory().AddItem(this.srch.item3, this.srch.quantity3);
                    TyreDatGameUtils.ProcessFlag(this.srch.flagIndex, this.srch.flagDir);
                    TyreDatGameUtils.ProcessFlag(this.srch.flagIndex2, this.srch.flagDir);
                    TyreDatGameUtils.ProcessFlag(this.srch.flagIndex3, this.srch.flagDir);
                    TyreDatGameUtils.ProcessFlag(this.srch.flagIndex4, this.srch.flagDir);
                    TyreDatGameUtils.ProcessFlag(this.srch.flagIndex5, this.srch.flagDir);
                }
            }
        }
        if (!this.found) {
            this.sres = GamePanel.PC.GetInventory().PerformGenericSearch();
            if (this.sres.found) {
                GamePanel.PC.GetInventory().AddItem(this.sres);
                this.msg = this.sres.message;
                this.found = true;
                this.foundItem = true;
            }
        }
        if (!this.found) {
            if (SEARCH_COUNT_RECENT >= IRITATION_LEVELS[0] && SEARCH_COUNT_RECENT < IRITATION_LEVELS[1]) {
                this.msg = "Surprise, surprise, and here I thought you were going to do something different. Shoulda known.";
            } else if (SEARCH_COUNT_RECENT >= IRITATION_LEVELS[1] && SEARCH_COUNT_RECENT < IRITATION_LEVELS[2]) {
                this.msg = "I mean like how many times are we gonna go through this same thing expecting a different result.";
            } else if (SEARCH_COUNT_RECENT >= IRITATION_LEVELS[2]) {
                this.msg = "Look it's not you, it's me, ok. I'm the one who just can't take searching anymore.";
                SEARCH_COUNT_RECENT = 0;
            }
        }
        if (this.found) {
            MmgVector2 tpos;
            int h;
            int w;
            MmgBmp item;
            ++GamePanel.PC.GetState().searchFindCount;
            SEARCH_COUNT_RECENT = 0;
            MmgFont ftmp = MmgFontData.CreateDefaultBoldMmgFontSm();
            int mw = this.menuBground.GetWidth();
            int mh = this.menuBground.GetHeight();
            int offsetX = MmgHelper.ScaleValue((int)4);
            int offsetY = MmgHelper.ScaleValue((int)4);
            if (this.foundItem) {
                this.tItm = new TyreItem(ResourceContainer.items[this.sres.itemIndex]);
                this.tItm.SetMmgColor(MmgColor.GetBlack());
                item = this.tItm.GetImage();
                w = item.GetWidth();
                h = item.GetHeight();
                tpos = new MmgVector2((mw - w) / 2, (mh - h) / 2);
                this.p.DrawBmp(item, tpos);
            } else if (this.foundSearch) {
                int ltmpX;
                int ctmp;
                if (icnt == 1) {
                    this.tItm = new TyreItem(ResourceContainer.items[ResourceContainer.searches[sidx].item1]);
                    this.tItm.SetMmgColor(MmgColor.GetBlack());
                    item = this.tItm.GetImage();
                    w = item.GetWidth();
                    h = item.GetHeight();
                    tpos = new MmgVector2((mw - w) / 2, (mh - h - offsetY - ftmp.GetHeight() - MmgHelper.ScaleValue((int)60)) / 2);
                    this.p.DrawBmp(item, tpos);
                    ctmp = ResourceContainer.searches[sidx].quantity1;
                    ftmp = MmgFontData.CreateDefaultBoldMmgFontSm();
                    ftmp.SetText("+ " + ctmp);
                    ftmp.SetPosition(new MmgVector2(tpos.GetX() + w - ftmp.GetWidth() - offsetX, tpos.GetY() + h + ftmp.GetHeight() + offsetY));
                    this.p.DrawText(ftmp);
                } else if (icnt == 2) {
                    this.tItm = new TyreItem(ResourceContainer.items[ResourceContainer.searches[sidx].item1]);
                    this.tItm.SetMmgColor(MmgColor.GetBlack());
                    item = this.tItm.GetImage();
                    w = item.GetWidth();
                    h = item.GetHeight();
                    ltmpX = (mw - w - w - offsetX) / 2;
                    tpos = new MmgVector2(ltmpX, (mh - h - offsetY - ftmp.GetHeight() - MmgHelper.ScaleValue((int)60)) / 2);
                    this.p.DrawBmp(item, tpos);
                    ctmp = ResourceContainer.searches[sidx].quantity1;
                    ftmp = MmgFontData.CreateDefaultBoldMmgFontSm();
                    ftmp.SetText("+ " + ctmp);
                    ftmp.SetPosition(new MmgVector2(tpos.GetX() + w - ftmp.GetWidth() - offsetX, tpos.GetY() + h + ftmp.GetHeight() + offsetY));
                    this.p.DrawText(ftmp);
                    this.tItm = new TyreItem(ResourceContainer.items[ResourceContainer.searches[sidx].item2]);
                    this.tItm.SetMmgColor(MmgColor.GetBlack());
                    item = this.tItm.GetImage();
                    w = item.GetWidth();
                    h = item.GetHeight();
                    tpos = new MmgVector2(ltmpX + w + offsetX, (mh - h) / 2);
                    this.p.DrawBmp(item, tpos);
                    ctmp = ResourceContainer.searches[sidx].quantity2;
                    ftmp = MmgFontData.CreateDefaultBoldMmgFontSm();
                    ftmp.SetText("+ " + ctmp);
                    ftmp.SetPosition(new MmgVector2(tpos.GetX() + w - ftmp.GetWidth() - offsetX, tpos.GetY() + h + ftmp.GetHeight() + offsetY));
                    this.p.DrawText(ftmp);
                } else if (icnt == 3) {
                    this.tItm = new TyreItem(ResourceContainer.items[ResourceContainer.searches[sidx].item1]);
                    this.tItm.SetMmgColor(MmgColor.GetBlack());
                    item = this.tItm.GetImage();
                    w = item.GetWidth();
                    h = item.GetHeight();
                    ltmpX = (mw - w - w - offsetX) / 2;
                    int ltmpY = (mh - h - h - offsetY - offsetY - ftmp.GetHeight() - ftmp.GetHeight() - MmgHelper.ScaleValue((int)60)) / 2;
                    tpos = new MmgVector2(ltmpX, ltmpY);
                    this.p.DrawBmp(item, tpos);
                    ctmp = ResourceContainer.searches[sidx].quantity1;
                    ftmp = MmgFontData.CreateDefaultBoldMmgFontSm();
                    ftmp.SetText("+ " + ctmp);
                    ftmp.SetPosition(new MmgVector2(tpos.GetX() + w - ftmp.GetWidth() - offsetX, tpos.GetY() + h + ftmp.GetHeight() + offsetY));
                    this.p.DrawText(ftmp);
                    this.tItm = new TyreItem(ResourceContainer.items[ResourceContainer.searches[sidx].item2]);
                    this.tItm.SetMmgColor(MmgColor.GetBlack());
                    item = this.tItm.GetImage();
                    w = item.GetWidth();
                    h = item.GetHeight();
                    tpos = new MmgVector2(ltmpX + w + offsetX, ltmpY);
                    this.p.DrawBmp(item, tpos);
                    ctmp = ResourceContainer.searches[sidx].quantity2;
                    ftmp = MmgFontData.CreateDefaultBoldMmgFontSm();
                    ftmp.SetText("+ " + ctmp);
                    ftmp.SetPosition(new MmgVector2(tpos.GetX() + w - ftmp.GetWidth() - offsetX, tpos.GetY() + h + ftmp.GetHeight() + offsetY));
                    this.p.DrawText(ftmp);
                    this.tItm = new TyreItem(ResourceContainer.items[ResourceContainer.searches[sidx].item3]);
                    this.tItm.SetMmgColor(MmgColor.GetBlack());
                    item = this.tItm.GetImage();
                    w = item.GetWidth();
                    h = item.GetHeight();
                    tpos = new MmgVector2((mw - w) / 2, ltmpY + h + ftmp.GetHeight() + offsetY);
                    this.p.DrawBmp(item, tpos);
                    ctmp = ResourceContainer.searches[sidx].quantity3;
                    ftmp = MmgFontData.CreateDefaultBoldMmgFontSm();
                    ftmp.SetText("+ " + ctmp);
                    ftmp.SetPosition(new MmgVector2(tpos.GetX() + w - ftmp.GetWidth() - offsetX, tpos.GetY() + h + ftmp.GetHeight() + offsetY));
                    this.p.DrawText(ftmp);
                }
            }
        }
        this.text.PrepLinesInBox(this.text.GetLinesInBox());
        this.text.PrepTextSplit(this.msg, MmgFontData.GetFontNorm(), MmgFontData.GetFontSize(), this.text.GetWidth());
        this.text.PrepPage(0);
        int diff = this.text.GetLinesInBox() - this.text.GetUsedLineCount();
        for (int i = 0; i < diff; ++i) {
            this.msg = this.msg + " [b]";
        }
        this.msg = this.msg + " (Press B to Close)";
        TyreDatGameUtils.wr(this.msg);
        this.text.PrepLinesInBox(this.text.GetLinesInBox());
        this.text.PrepTextSplit(this.msg, MmgFontData.GetFontNorm(), MmgFontData.GetFontSize(), this.text.GetWidth());
        this.text.PrepPage(0);
        ++SEARCH_COUNT_RECENT;
        ++SEARCH_COUNT_TOTAL;
        ++GamePanel.PC.GetState().searchCount;
        this.pause = false;
    }

    public final void UnloadResources() {
        this.dirty = false;
        this.pause = true;
        this.SetIsVisible(false);
        this.img = null;
        this.bground = null;
        this.menuBground = null;
        this.text = null;
        this.startPos = null;
        this.finishPos = null;
        this.posTween = null;
        this.bg = null;
        this.bgGraphics = null;
        this.p = null;
        this.mainGameScreen = null;
        this.ready = false;
    }

    public final TyreOverworldViewActionSearch Clone() {
        TyreOverworldViewActionSearch ret = new TyreOverworldViewActionSearch(this.bground, this.mainGameScreen, this.paddingX, this.paddingY, this.offsetX, this.offsetY);
        ret.SetPosition(this.GetPosition());
        ret.SetWidth(this.GetWidth());
        ret.SetHeight(this.GetHeight());
        return ret;
    }

    public final void MmgDraw(MmgPen p) {
        if (!this.pause && this.isVisible) {
            p.DrawBmp(this.img, this.img.GetPosition());
            this.text.MmgDraw(p);
        }
    }

    public final boolean MmgUpdate(int updateTick, long currentTimeMs, long msSinceLastFrame) {
        if (this.pause) {
            return false;
        }
        this.lret = false;
        if (this.isVisible && this.posTween != null) {
            this.posTween.MmgUpdate(updateTick, currentTimeMs, msSinceLastFrame);
        }
        if (this.dirty) {
            this.lret = true;
        }
        if (this.lret) {
            this.DrawScreen();
        }
        return this.lret;
    }

    public final void AnimateInStart() {
        this.posTween.SetDirStartToFinish(true);
        this.posTween.SetMsStartMove(System.currentTimeMillis());
        this.posTween.SetMoving(true);
    }

    public final void AnimateOutStart() {
        this.posTween.SetDirStartToFinish(false);
        this.posTween.SetMsStartMove(System.currentTimeMillis());
        this.posTween.SetMoving(true);
    }

    public final void SetPosition(MmgVector2 v) {
        super.SetPosition(v);
        if (this.img != null) {
            this.img.SetPosition(v);
        }
        if (this.text != null) {
            this.text.SetPosition(new MmgVector2(v.GetX() + this.lp, v.GetY() + this.lp));
        }
    }

    public final MmgVector2 GetPosition() {
        if (this.img != null) {
            return this.img.GetPosition();
        }
        return this.GetPosition();
    }

    public final void SetWidth(int i) {
        super.SetWidth(i);
        if (this.img != null) {
            this.img.SetWidth(i);
        }
    }

    public final int GetWidth() {
        if (this.img != null) {
            return this.img.GetWidth();
        }
        return super.GetWidth();
    }

    public final void SetHeight(int i) {
        super.SetHeight(i);
        if (this.img != null) {
            this.img.SetHeight(i);
        }
    }

    public final int GetHeight() {
        if (this.img != null) {
            return this.img.GetHeight();
        }
        return super.GetHeight();
    }
}

