/*
 * Decompiled with CFR 0.152.
 */
package com.middlemindgames.TyreObjects;

import com.middlemindgames.TyreGame.ControlBgroundStory;
import com.middlemindgames.TyreGame.DatConstants;
import com.middlemindgames.TyreGame.GamePanel;
import com.middlemindgames.TyreGame.GameSettings;
import com.middlemindgames.TyreGame.ScreenMainGame;
import com.middlemindgames.TyreGame.TyreDatGameUtils;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import net.middlemind.MmgGameApiJava.MmgBase.Mmg9Slice;
import net.middlemind.MmgGameApiJava.MmgBase.MmgBmp;
import net.middlemind.MmgGameApiJava.MmgBase.MmgBmpScaler;
import net.middlemind.MmgGameApiJava.MmgBase.MmgColor;
import net.middlemind.MmgGameApiJava.MmgBase.MmgEventHandler;
import net.middlemind.MmgGameApiJava.MmgBase.MmgFont;
import net.middlemind.MmgGameApiJava.MmgBase.MmgFontData;
import net.middlemind.MmgGameApiJava.MmgBase.MmgHelper;
import net.middlemind.MmgGameApiJava.MmgBase.MmgObj;
import net.middlemind.MmgGameApiJava.MmgBase.MmgPen;
import net.middlemind.MmgGameApiJava.MmgBase.MmgPositionTween;
import net.middlemind.MmgGameApiJava.MmgBase.MmgScreenData;
import net.middlemind.MmgGameApiJava.MmgBase.MmgVector2;

public final class TyreOverworldViewActionStats
extends MmgObj {
    private boolean ready;
    private boolean dirty = false;
    private boolean pause = false;
    private boolean lret;
    private MmgBmp img;
    private MmgBmp bground;
    private Mmg9Slice menuBground;
    private MmgVector2 startPos;
    private MmgVector2 finishPos;
    private MmgPositionTween posTween;
    private ControlBgroundStory text;
    private final int paddingX;
    private final int paddingY;
    private final int offsetX;
    private final int offsetY;
    private BufferedImage bg;
    private Graphics2D bgGraphics;
    private MmgPen p;
    private ScreenMainGame mainGameScreen;
    private final int lp;
    private String msg;
    private TyreStatsPage page;

    public TyreOverworldViewActionStats(MmgBmp Bground, ScreenMainGame mgs, int PaddingX, int PaddingY, int OffsetX, int OffsetY) {
        this.bground = Bground;
        this.paddingX = PaddingX;
        this.paddingY = PaddingY;
        this.offsetX = OffsetX;
        this.offsetY = OffsetY;
        this.lp = MmgHelper.ScaleValue((int)10);
        this.mainGameScreen = mgs;
        this.ready = false;
        this.page = TyreStatsPage.PAGE_1;
        this.LoadResources();
    }

    public void SetFinishEventId(int i) {
        if (this.posTween != null) {
            this.posTween.SetFinishEventId(i);
        }
    }

    public void SetStartEventId(int i) {
        if (this.posTween != null) {
            this.posTween.SetStartEventId(i);
        }
    }

    public void SetEventHandler(MmgEventHandler h) {
        if (this.posTween != null) {
            this.posTween.SetOnReachFinish(h);
            this.posTween.SetOnReachStart(h);
        }
    }

    public final boolean IsReady() {
        return this.ready;
    }

    public final void SetReady(boolean b) {
        this.ready = b;
    }

    public final boolean IsPaused() {
        return this.pause;
    }

    public final void SetPaused(boolean b) {
        this.pause = b;
    }

    public final boolean IsDirty() {
        return this.dirty;
    }

    public final void SetDirty(boolean b) {
        this.dirty = b;
    }

    public final MmgBmp GetImage() {
        return this.img;
    }

    public final void SetImage(MmgBmp lImg) {
        this.img = lImg;
    }

    private void PrepBuffers(int w, int h) {
        this.bg = this.create(w, h, false);
        this.bgGraphics = (Graphics2D)this.bg.getGraphics();
    }

    private BufferedImage create(int width, int height, boolean alpha) {
        return MmgBmpScaler.GRAPHICS_CONFIG.createCompatibleImage(width, height, alpha ? 3 : 1);
    }

    public final void LoadResources() {
        this.pause = true;
        int menuWidth = this.paddingY + MmgHelper.ScaleValue((int)DatConstants.DIALOG_STATS_WIDTH) + this.paddingY;
        int menuHeight = this.paddingY + MmgHelper.ScaleValue((int)DatConstants.DIALOG_STATS_HEIGHT) + this.paddingY;
        int totalWidth = this.offsetX + menuWidth + this.offsetX;
        int totalHeight = this.offsetY + menuHeight + this.offsetY;
        int padding = MmgHelper.ScaleValue((int)20);
        this.menuBground = new Mmg9Slice(16, this.bground, totalWidth, totalHeight);
        this.menuBground.SetPosition(MmgVector2.GetOriginVec());
        this.menuBground.SetWidth(totalWidth);
        this.menuBground.SetHeight(totalHeight);
        MmgHelper.CenterHorAndVert((MmgObj)this.menuBground);
        this.startPos = new MmgVector2(this.menuBground.GetPosition().GetX(), MmgScreenData.GetGameTop() - totalHeight - MmgHelper.ScaleValue((int)10));
        this.finishPos = this.menuBground.GetPosition().Clone();
        this.SetPosition(this.startPos);
        this.SetWidth(totalWidth);
        this.SetHeight(totalHeight);
        this.menuBground.SetPosition(MmgVector2.GetOriginVec());
        TyreDatGameUtils.wr("OverworldViewActionStats: " + totalWidth + "x" + totalHeight);
        if (this.bgGraphics == null) {
            this.PrepBuffers(this.w, this.h);
        }
        this.p = new MmgPen();
        this.p.SetGraphics((Graphics)this.bgGraphics);
        this.p.SetAdvRenderHints();
        this.img = new MmgBmp((Image)this.bg);
        TyreDatGameUtils.wr("Found start pos: " + this.startPos.ToString());
        TyreDatGameUtils.wr("Found end pos: " + this.finishPos.ToString());
        this.posTween = new MmgPositionTween((MmgObj)this, DatConstants.ANIMATION_TIME_MS_OVERWORLD_STATS, this.startPos, this.finishPos);
        this.SetPosition(this.startPos);
        this.SetWidth(totalWidth);
        this.SetHeight(totalHeight);
        this.text = new ControlBgroundStory();
        this.text.SetLineHeight(MmgFontData.GetTargetPixelHeightScaled() + MmgHelper.ScaleValue((int)2));
        this.text.SetHeight(totalHeight - padding);
        this.text.SetWidth(totalWidth - padding);
        this.text.SetPaddingX(MmgHelper.ScaleValue((int)this.text.GetPaddingX()));
        this.text.SetPaddingY(MmgHelper.ScaleValue((int)this.text.GetPaddingY()));
        this.text.SetPosition(this.startPos);
        this.text.SetColor(MmgColor.GetWhite());
        this.ready = true;
        this.pause = false;
    }

    public final void DrawScreen() {
        this.pause = true;
        this.menuBground.MmgDraw(this.p);
        if (this.page == TyreStatsPage.PAGE_1) {
            this.msg = "[b] [b] -- Overworld Statistics --";
            this.msg = this.msg + " [b] Steps Taken: " + GamePanel.PC.GetState().stepCount;
            this.msg = this.msg + " [b] Searches: " + GamePanel.PC.GetState().searchCount;
            this.msg = this.msg + " [b] Successful Searches: " + GamePanel.PC.GetState().searchFindCount;
            this.msg = this.msg + " [b] Investigations: " + GamePanel.PC.GetState().investigateCount;
            this.msg = this.msg + " [b] Investigation Finds: " + GamePanel.PC.GetState().investigateFindCount;
            this.msg = this.msg + " [b] Conversations: " + GamePanel.PC.GetState().talkCount;
            this.msg = this.msg + " [b] Gold Accumulated: " + GamePanel.PC.GetState().goldAccumulated;
            this.msg = this.msg + " [b] Gold Spent: " + GamePanel.PC.GetState().goldSpent;
        } else if (this.page == TyreStatsPage.PAGE_2) {
            this.msg = " [b] [b] -- Battle Statistics --";
            this.msg = this.msg + " [b] Battle Count: " + GamePanel.PC.GetState().battleCount;
            this.msg = this.msg + " [b] Battle Win Count: " + GamePanel.PC.GetState().battleWinCount;
            this.msg = this.msg + " [b] Battle Loss Count: " + GamePanel.PC.GetState().battleLossCount;
            this.msg = this.msg + " [b] Battle Ambush Count: " + GamePanel.PC.GetState().battleAmbushCount;
            this.msg = this.msg + " [b] Battle Ambush Win Count: " + GamePanel.PC.GetState().battleAmbushWinCount;
            this.msg = this.msg + " [b] Battle Ambush Loss Count: " + GamePanel.PC.GetState().battleAmbushLossCount;
            this.msg = this.msg + " [b] Battle Preemptive Count: " + GamePanel.PC.GetState().battlePreemptiveCount;
            this.msg = this.msg + " [b] Battle Preemptive Win Count: " + GamePanel.PC.GetState().battlePreemptiveWinCount;
            this.msg = this.msg + " [b] Battle Preemptive Loss Count: " + GamePanel.PC.GetState().battlePreemptiveLossCount;
            this.msg = this.msg + " [b] Glancing Blows: " + GamePanel.PC.GetState().blowGlancingCount;
            this.msg = this.msg + " [b] Missed Blows: " + GamePanel.PC.GetState().blowMissedCount;
            this.msg = this.msg + " [b] Ultimate Blows: " + GamePanel.PC.GetState().blowUltimateCount;
        }
        int offsetX = MmgHelper.ScaleValue((int)4);
        int offsetY = MmgHelper.ScaleValue((int)4);
        MmgFont tfnt = MmgFontData.CreateDefaultBoldMmgFontLg();
        MmgBmp btmp = TyreDatGameUtils.GetDatCachedConsoleBmp(7, GameSettings.BMP_PREFIX_CONSOLE + 7);
        MmgVector2 tpos = new MmgVector2(MmgHelper.ScaleValue((int)10), MmgHelper.ScaleValue((int)10));
        this.p.DrawBmp(btmp, tpos);
        tfnt.SetText("Player Statistics");
        tfnt.SetPosition(new MmgVector2(tpos.GetX() + btmp.GetWidth() + offsetX, tpos.GetY() + offsetY + tfnt.GetHeight()));
        this.p.DrawText(tfnt);
        this.text.PrepLinesInBox(this.text.GetLinesInBox());
        this.text.PrepTextSplit(this.msg, MmgFontData.GetFontNorm(), MmgFontData.GetFontSize(), this.text.GetWidth());
        this.text.PrepPage(0);
        int diff = this.text.GetLinesInBox() - this.text.GetUsedLineCount() - 3;
        for (int i = 0; i < diff; ++i) {
            this.msg = this.msg + " [b]";
        }
        if (this.page == TyreStatsPage.PAGE_1) {
            this.msg = this.msg + " [b] (Press B to Close)         (Press A for Next)";
        } else if (this.page == TyreStatsPage.PAGE_2) {
            this.msg = this.msg + " [b] (Press A for Prev)         (Press B to Close)";
        }
        TyreDatGameUtils.wr(this.msg);
        this.text.PrepLinesInBox(this.text.GetLinesInBox());
        this.text.PrepTextSplit(this.msg, MmgFontData.GetFontNorm(), MmgFontData.GetFontSize(), this.text.GetWidth());
        this.text.PrepPage(0);
        this.pause = false;
    }

    public final void UnloadResources() {
        this.dirty = false;
        this.pause = true;
        this.SetIsVisible(false);
        this.img = null;
        this.bground = null;
        this.menuBground = null;
        this.text = null;
        this.startPos = null;
        this.finishPos = null;
        this.posTween = null;
        this.bg = null;
        this.bgGraphics = null;
        this.p = null;
        this.mainGameScreen = null;
        this.ready = false;
    }

    public final TyreOverworldViewActionStats Clone() {
        TyreOverworldViewActionStats ret = new TyreOverworldViewActionStats(this.bground, this.mainGameScreen, this.paddingX, this.paddingY, this.offsetX, this.offsetY);
        ret.SetPosition(this.GetPosition());
        ret.SetWidth(this.GetWidth());
        ret.SetHeight(this.GetHeight());
        return ret;
    }

    public final void MmgDraw(MmgPen p) {
        if (this.isVisible) {
            p.DrawBmp(this.img, this.img.GetPosition());
            this.text.MmgDraw(p);
        }
    }

    public final boolean MmgUpdate(int updateTick, long currentTimeMs, long msSinceLastFrame) {
        if (this.pause) {
            return false;
        }
        this.lret = false;
        if (this.isVisible && this.posTween != null) {
            this.posTween.MmgUpdate(updateTick, currentTimeMs, msSinceLastFrame);
        }
        if (this.dirty) {
            this.lret = true;
        }
        if (this.lret) {
            this.DrawScreen();
        }
        return this.lret;
    }

    public final void AnimateInStart() {
        this.posTween.SetDirStartToFinish(true);
        this.posTween.SetMsStartMove(System.currentTimeMillis());
        this.posTween.SetMoving(true);
    }

    public final void AnimateOutStart() {
        this.posTween.SetDirStartToFinish(false);
        this.posTween.SetMsStartMove(System.currentTimeMillis());
        this.posTween.SetMoving(true);
    }

    public final void SetPosition(MmgVector2 v) {
        super.SetPosition(v);
        if (this.img != null) {
            this.img.SetPosition(v);
        }
        if (this.text != null) {
            this.text.SetPosition(new MmgVector2(v.GetX() + this.lp, v.GetY() + this.lp));
        }
    }

    public final MmgVector2 GetPosition() {
        if (this.img != null) {
            return this.img.GetPosition();
        }
        return this.GetPosition();
    }

    public final void SetWidth(int i) {
        super.SetWidth(i);
        if (this.img != null) {
            this.img.SetWidth(i);
        }
    }

    public final int GetWidth() {
        if (this.img != null) {
            return this.img.GetWidth();
        }
        return super.GetWidth();
    }

    public final void SetHeight(int i) {
        super.SetHeight(i);
        if (this.img != null) {
            this.img.SetHeight(i);
        }
    }

    public final int GetHeight() {
        if (this.img != null) {
            return this.img.GetHeight();
        }
        return super.GetHeight();
    }

    public static enum TyreStatsPage {
        PAGE_1,
        PAGE_2;

    }
}

