/*
 * Decompiled with CFR 0.152.
 */
package com.middlemindgames.TyreObjects;

import com.middlemindgames.TyreGame.CollisionResult;
import com.middlemindgames.TyreGame.DatConstants;
import com.middlemindgames.TyreGame.GamePanel;
import com.middlemindgames.TyreGame.GameSettings;
import com.middlemindgames.TyreGame.ScreenMainGame;
import com.middlemindgames.TyreGame.TyreDatGameUtils;
import com.middlemindgames.TyreObjects.TyreInventory;
import com.middlemindgames.TyreObjects.TyreLinkTable;
import com.middlemindgames.TyreObjects.TyreNpc;
import com.middlemindgames.TyreObjects.TyreOverworldView;
import com.middlemindgames.TyreObjects.TyreOverworldViewActionInvestigate;
import com.middlemindgames.TyreObjects.TyreOverworldViewActionSearch;
import com.middlemindgames.TyreObjects.TyreState;
import com.middlemindgames.dat.Player;
import com.middlemindgames.dat.ResourceContainer;
import net.middlemind.MmgGameApiJava.MmgBase.MmgBmp;
import net.middlemind.MmgGameApiJava.MmgBase.MmgEvent;
import net.middlemind.MmgGameApiJava.MmgBase.MmgEventHandler;
import net.middlemind.MmgGameApiJava.MmgBase.MmgHelper;
import net.middlemind.MmgGameApiJava.MmgBase.MmgObj;
import net.middlemind.MmgGameApiJava.MmgBase.MmgPen;
import net.middlemind.MmgGameApiJava.MmgBase.MmgRect;
import net.middlemind.MmgGameApiJava.MmgBase.MmgSprite;
import net.middlemind.MmgGameApiJava.MmgBase.MmgVector2;

public final class TyrePc
extends MmgObj
implements MmgEventHandler {
    private Player datObj;
    private boolean ready;
    private MmgSprite pc;
    private String[] pcImgIds;
    private int[] pcImgIdxs;
    private int currentDir;
    private int nextDir;
    private int currentFoot;
    private int prevFoot;
    private int currentState;
    private TyreNpc.NpcRenderMode pcRenderMode;
    private int msPerFrame;
    private TyreOverworldView.RoomViewIndex roomViewIndex;
    private boolean lret;
    public static int DEFAULT_MS_PER_FRAME_PACING = 500;
    public static int DEFAULT_MS_PER_FRAME_WALKING = 250;
    public static int VERT_OFFSET = MmgHelper.ScaleValue((int)DatConstants.PC_OFFSET_Y);
    public int SPEED = MmgHelper.ScaleValue((int)DatConstants.PC_SPEED) + 1;
    private CollisionResult diffLocal = null;
    private CollisionResult diffOverworld = null;
    private TyreLinkTable pcRoomView = null;
    public static boolean LIMIT_MOVEMENT_AT_ROOM_EDGES = false;
    private MmgRect pcRect;
    private boolean reachedRoomCenter;
    private TyreInventory inventory;
    private TyreState state = new TyreState();
    private boolean pause = false;

    public TyrePc(Player pcd) {
        this.inventory = new TyreInventory();
        VERT_OFFSET = MmgHelper.ScaleValue((int)DatConstants.PC_OFFSET_Y);
        this.SPEED = MmgHelper.ScaleValue((int)DatConstants.PC_SPEED) + 1;
        this.roomViewIndex = TyreOverworldView.RoomViewIndex.ROOM_VIEW_INDEX_NONE;
        this.pcRenderMode = TyreNpc.NpcRenderMode.PREVIEW;
        this.currentState = DatConstants.NPC_STATE_PACING;
        this.SetDatObj(pcd);
        this.pc = null;
        this.ready = false;
        this.reachedRoomCenter = false;
        this.LoadResources();
    }

    public TyrePc(Player pcd, TyreNpc.NpcRenderMode mode) {
        this.inventory = new TyreInventory();
        VERT_OFFSET = MmgHelper.ScaleValue((int)DatConstants.PC_OFFSET_Y);
        this.SPEED = MmgHelper.ScaleValue((int)DatConstants.PC_SPEED) + 1;
        this.roomViewIndex = TyreOverworldView.RoomViewIndex.ROOM_VIEW_INDEX_NONE;
        this.pcRenderMode = mode;
        this.currentState = DatConstants.NPC_STATE_PACING;
        this.SetDatObj(pcd);
        this.pc = null;
        this.ready = false;
        this.reachedRoomCenter = false;
        this.LoadResources();
    }

    public TyrePc(Player pcd, TyreNpc.NpcRenderMode mode, MmgSprite lSprite) {
        this.inventory = new TyreInventory();
        VERT_OFFSET = MmgHelper.ScaleValue((int)DatConstants.PC_OFFSET_Y);
        this.SPEED = MmgHelper.ScaleValue((int)DatConstants.PC_SPEED) + 1;
        this.roomViewIndex = TyreOverworldView.RoomViewIndex.ROOM_VIEW_INDEX_NONE;
        this.pcRenderMode = mode;
        this.currentState = DatConstants.NPC_STATE_PACING;
        this.SetDatObj(pcd);
        this.pc = lSprite;
        this.ready = true;
        this.reachedRoomCenter = false;
    }

    public final int GetAp() {
        return this.datObj.ap;
    }

    public final int GetDp() {
        return this.datObj.dp;
    }

    public final int GetEx() {
        return this.datObj.ex;
    }

    public final int GetHp() {
        return this.datObj.hp;
    }

    public final int GetLv() {
        return this.datObj.lv;
    }

    public final int GetMp() {
        return this.datObj.mp;
    }

    public final int GetStartingRoom() {
        return this.datObj.startingRoom;
    }

    public final int GetBc() {
        return this.datObj.bc;
    }

    public final int GetBl() {
        return this.datObj.bl;
    }

    public final int GetBr() {
        return this.datObj.br;
    }

    public final int GetFc() {
        return this.datObj.fc;
    }

    public final int GetFl() {
        return this.datObj.fl;
    }

    public final int GetFr() {
        return this.datObj.fr;
    }

    public final int GetNameStringIndex() {
        return this.datObj.stringIndex;
    }

    public final int GetLc() {
        return this.datObj.lc;
    }

    public final int GetLl() {
        return this.datObj.ll;
    }

    public final int GetLr() {
        return this.datObj.lr;
    }

    public final int GetRc() {
        return this.datObj.rc;
    }

    public final int GetRl() {
        return this.datObj.rl;
    }

    public final int GetRr() {
        return this.datObj.rr;
    }

    public final int GetSpeed() {
        return this.datObj.speed;
    }

    public final String GetNameString() {
        return ResourceContainer.strings[this.datObj.stringIndex];
    }

    public TyreState GetState() {
        return this.state;
    }

    public void SetState(TyreState s) {
        this.state = s;
    }

    public TyreInventory GetInventory() {
        return this.inventory;
    }

    public void SetInventory(TyreInventory i) {
        this.inventory = i;
    }

    public boolean HasReachedRoomCenter() {
        return this.reachedRoomCenter;
    }

    public void SetReachedRoomCenter(boolean b) {
        this.reachedRoomCenter = b;
    }

    public final int GetNextDir() {
        return this.nextDir;
    }

    public final void SetNextDir(int nd) {
        this.nextDir = nd;
    }

    public final void MmgHandleEvent(MmgEvent e) {
        if (e.GetEventId() == 0 && this.currentState != DatConstants.NPC_STATE_STILL) {
            if (this.currentFoot == DatConstants.NPC_FEET_LEFT) {
                this.FootCenter();
                this.prevFoot = DatConstants.NPC_FEET_LEFT;
            } else if (this.currentFoot == DatConstants.NPC_FEET_RIGHT) {
                this.FootCenter();
                this.prevFoot = DatConstants.NPC_FEET_RIGHT;
            } else if (this.currentFoot == DatConstants.NPC_FEET_CENTER) {
                if (this.prevFoot == DatConstants.NPC_FEET_RIGHT) {
                    this.FootLeft();
                } else if (this.prevFoot == DatConstants.NPC_FEET_LEFT) {
                    this.FootRight();
                }
            }
        }
    }

    public final TyreOverworldView.RoomViewIndex GetRoomViewIndex() {
        return this.roomViewIndex;
    }

    public final void SetRoomViewIndex(TyreOverworldView.RoomViewIndex roomViewIndex) {
        this.roomViewIndex = roomViewIndex;
    }

    public final int GetCurrentDir() {
        return this.currentDir;
    }

    public final void SetCurrentDir(int currentDir) {
        this.currentDir = currentDir;
    }

    public final int GetCurrentFoot() {
        return this.currentFoot;
    }

    public final void SetCurrentFoot(int currentFoot) {
        this.currentFoot = currentFoot;
    }

    public final int GetCurrentState() {
        return this.currentState;
    }

    public final void SetCurrentState(int currentState) {
        this.currentState = currentState;
    }

    public final TyreNpc.NpcRenderMode GetPcRenderMode() {
        return this.pcRenderMode;
    }

    public final void SetPcRenderMode(TyreNpc.NpcRenderMode mode) {
        this.pcRenderMode = mode;
        if (this.pcRenderMode == TyreNpc.NpcRenderMode.PREVIEW) {
            this.pc.SetOnFrameChange(null);
            this.pc.SetTimerOnly(false);
        } else {
            this.pc.SetOnFrameChange((MmgEventHandler)this);
            this.pc.SetTimerOnly(true);
        }
    }

    public final int GetMsPerFrame() {
        return this.msPerFrame;
    }

    public final void SetMsPerFrame(int i) {
        this.msPerFrame = i;
        this.pc.SetMsPerFrame((long)i);
    }

    public final MmgSprite GetPc() {
        return this.pc;
    }

    public final void SetPc(MmgSprite s) {
        this.pc = s;
    }

    public final void FootCenter() {
        if (this.currentDir == DatConstants.NPC_DIR_LEFT) {
            this.pc.SetFrameIdx(9);
        } else if (this.currentDir == DatConstants.NPC_DIR_RIGHT) {
            this.pc.SetFrameIdx(6);
        } else if (this.currentDir == DatConstants.NPC_DIR_FRONT) {
            this.pc.SetFrameIdx(0);
        } else if (this.currentDir == DatConstants.NPC_DIR_BACK) {
            this.pc.SetFrameIdx(3);
        }
        this.currentFoot = DatConstants.NPC_FEET_CENTER;
    }

    public final void FootLeft() {
        if (this.currentDir == DatConstants.NPC_DIR_LEFT) {
            this.pc.SetFrameIdx(11);
        } else if (this.currentDir == DatConstants.NPC_DIR_RIGHT) {
            this.pc.SetFrameIdx(8);
        } else if (this.currentDir == DatConstants.NPC_DIR_FRONT) {
            this.pc.SetFrameIdx(2);
        } else if (this.currentDir == DatConstants.NPC_DIR_BACK) {
            this.pc.SetFrameIdx(5);
        }
        this.currentFoot = DatConstants.NPC_FEET_LEFT;
    }

    public final void FootRight() {
        if (this.currentDir == DatConstants.NPC_DIR_LEFT) {
            this.pc.SetFrameIdx(10);
        } else if (this.currentDir == DatConstants.NPC_DIR_RIGHT) {
            this.pc.SetFrameIdx(7);
        } else if (this.currentDir == DatConstants.NPC_DIR_FRONT) {
            this.pc.SetFrameIdx(1);
        } else if (this.currentDir == DatConstants.NPC_DIR_BACK) {
            this.pc.SetFrameIdx(4);
        }
        this.currentFoot = DatConstants.NPC_FEET_RIGHT;
    }

    public final void FaceLeft() {
        this.pc.SetFrameIdx(9);
        this.currentDir = DatConstants.NPC_DIR_LEFT;
        this.currentFoot = DatConstants.NPC_FEET_CENTER;
    }

    public final void FaceRight() {
        this.pc.SetFrameIdx(6);
        this.currentDir = DatConstants.NPC_DIR_RIGHT;
        this.currentFoot = DatConstants.NPC_FEET_CENTER;
    }

    public final void FaceFront() {
        this.pc.SetFrameIdx(0);
        this.currentDir = DatConstants.NPC_DIR_FRONT;
        this.currentFoot = DatConstants.NPC_FEET_CENTER;
    }

    public final void FaceBack() {
        this.pc.SetFrameIdx(3);
        this.currentDir = DatConstants.NPC_DIR_BACK;
        this.currentFoot = DatConstants.NPC_FEET_CENTER;
    }

    public final boolean IsReady() {
        return this.ready;
    }

    public final void SetReady(boolean b) {
        this.ready = b;
    }

    public final Player GetDatObj() {
        return this.datObj;
    }

    public final void SetDatObj(Player pcd) {
        this.datObj = pcd;
        this.pcImgIds = new String[12];
        this.pcImgIds[0] = GameSettings.BMP_PREFIX + this.datObj.fc;
        this.pcImgIds[1] = GameSettings.BMP_PREFIX + this.datObj.fr;
        this.pcImgIds[2] = GameSettings.BMP_PREFIX + this.datObj.fl;
        this.pcImgIds[3] = GameSettings.BMP_PREFIX + this.datObj.bc;
        this.pcImgIds[4] = GameSettings.BMP_PREFIX + this.datObj.br;
        this.pcImgIds[5] = GameSettings.BMP_PREFIX + this.datObj.bl;
        this.pcImgIds[6] = GameSettings.BMP_PREFIX + this.datObj.rc;
        this.pcImgIds[7] = GameSettings.BMP_PREFIX + this.datObj.rr;
        this.pcImgIds[8] = GameSettings.BMP_PREFIX + this.datObj.rl;
        this.pcImgIds[9] = GameSettings.BMP_PREFIX + this.datObj.lc;
        this.pcImgIds[10] = GameSettings.BMP_PREFIX + this.datObj.lr;
        this.pcImgIds[11] = GameSettings.BMP_PREFIX + this.datObj.ll;
        this.pcImgIdxs = new int[12];
        this.pcImgIdxs[0] = this.datObj.fc;
        this.pcImgIdxs[1] = this.datObj.fr;
        this.pcImgIdxs[2] = this.datObj.fl;
        this.pcImgIdxs[3] = this.datObj.bc;
        this.pcImgIdxs[4] = this.datObj.br;
        this.pcImgIdxs[5] = this.datObj.bl;
        this.pcImgIdxs[6] = this.datObj.rc;
        this.pcImgIdxs[7] = this.datObj.rr;
        this.pcImgIdxs[8] = this.datObj.rl;
        this.pcImgIdxs[9] = this.datObj.lc;
        this.pcImgIdxs[10] = this.datObj.lr;
        this.pcImgIdxs[11] = this.datObj.ll;
    }

    public final int GetVertOffset() {
        return VERT_OFFSET;
    }

    public final MmgBmp GetCurrentFrame() {
        return this.pc.GetCurrentFrame();
    }

    public final int GetStartingDir() {
        return DatConstants.NPC_DIR_FRONT;
    }

    public final MmgRect GetSearchCollisionRect() {
        if (this.currentDir == DatConstants.NPC_DIR_RIGHT) {
            return new MmgRect(new MmgVector2(this.GetX() + this.GetWidth(), this.GetY() - (this.GetWidth() * 3 - this.GetHeight()) / 2), this.GetHeight() - this.GetVertOffset(), this.GetWidth() * 3);
        }
        if (this.currentDir == DatConstants.NPC_DIR_LEFT) {
            return new MmgRect(new MmgVector2(this.GetX() - (this.GetHeight() - this.GetVertOffset()), this.GetY() - (this.GetWidth() * 3 - this.GetHeight()) / 2), this.GetHeight() - this.GetVertOffset(), this.GetWidth() * 3);
        }
        if (this.currentDir == DatConstants.NPC_DIR_FRONT) {
            return new MmgRect(new MmgVector2(this.GetX() - this.GetWidth(), this.GetY() + this.GetHeight() - this.GetVertOffset()), this.GetWidth() * 3, this.GetHeight() - this.GetVertOffset());
        }
        if (this.currentDir == DatConstants.NPC_DIR_BACK) {
            return new MmgRect(new MmgVector2(this.GetX() - this.GetWidth(), this.GetY() - this.GetHeight() + this.GetVertOffset() + this.GetVertOffset()), this.GetWidth() * 3, this.GetHeight() - this.GetVertOffset());
        }
        return this.GetPseudoDepthCollisionRect();
    }

    public final MmgRect GetInvestigateCollisionRect() {
        if (this.currentDir == DatConstants.NPC_DIR_RIGHT) {
            return new MmgRect(new MmgVector2(this.GetX() + this.GetWidth(), this.GetY()), this.GetHeight() / 2, this.GetWidth() / 2);
        }
        if (this.currentDir == DatConstants.NPC_DIR_LEFT) {
            return new MmgRect(new MmgVector2(this.GetX() - this.GetHeight() / 2, this.GetY()), this.GetHeight() / 2, this.GetWidth() / 2);
        }
        if (this.currentDir == DatConstants.NPC_DIR_FRONT) {
            return new MmgRect(new MmgVector2(this.GetX() + (this.GetWidth() - this.GetWidth() / 2) / 2, this.GetY() + this.GetHeight()), this.GetWidth() / 2, this.GetHeight() / 2);
        }
        if (this.currentDir == DatConstants.NPC_DIR_BACK) {
            return new MmgRect(new MmgVector2(this.GetX() + (this.GetWidth() - this.GetWidth() / 2) / 2, this.GetY() - this.GetHeight() / 2), this.GetWidth() / 2, this.GetHeight() / 2);
        }
        return this.GetPseudoDepthCollisionRect();
    }

    public final MmgRect GetPseudoDepthCollisionRect() {
        return new MmgRect(new MmgVector2(this.GetX(), this.GetY() + this.GetHeight() - VERT_OFFSET), this.GetWidth(), VERT_OFFSET);
    }

    public final int GetPseudoDepthCollisionY() {
        return this.GetY() + this.GetHeight() - VERT_OFFSET;
    }

    public final MmgRect GetCollisionRect() {
        return new MmgRect(new MmgVector2(this.GetX(), this.GetY()), this.GetWidth(), this.GetHeight());
    }

    public final MmgRect GetPseudoDepthWalkCollisionRect() {
        if (this.currentState == DatConstants.NPC_STATE_WALKING) {
            if (this.currentDir == DatConstants.NPC_DIR_RIGHT) {
                return new MmgRect(new MmgVector2(this.GetX() + this.SPEED, this.GetY() + this.GetHeight() - VERT_OFFSET), this.GetWidth(), VERT_OFFSET);
            }
            if (this.currentDir == DatConstants.NPC_DIR_LEFT) {
                return new MmgRect(new MmgVector2(this.GetX() - this.SPEED, this.GetY() + this.GetHeight() - VERT_OFFSET), this.GetWidth(), VERT_OFFSET);
            }
            if (this.currentDir == DatConstants.NPC_DIR_FRONT) {
                return new MmgRect(new MmgVector2(this.GetX(), this.GetY() + this.GetHeight() - VERT_OFFSET + this.SPEED), this.GetWidth(), VERT_OFFSET);
            }
            if (this.currentDir == DatConstants.NPC_DIR_BACK) {
                return new MmgRect(new MmgVector2(this.GetX(), this.GetY() + this.GetHeight() - VERT_OFFSET - this.SPEED), this.GetWidth(), VERT_OFFSET);
            }
            return this.GetPseudoDepthCollisionRect();
        }
        return this.GetPseudoDepthCollisionRect();
    }

    public final MmgRect GetProjectedPseudoDepthWalkCollisionRect(int dir) {
        if (dir == DatConstants.NPC_DIR_RIGHT) {
            return new MmgRect(new MmgVector2(this.GetX() + this.SPEED, this.GetY() + this.GetHeight() - VERT_OFFSET), this.GetWidth(), VERT_OFFSET);
        }
        if (dir == DatConstants.NPC_DIR_LEFT) {
            return new MmgRect(new MmgVector2(this.GetX() - this.SPEED, this.GetY() + this.GetHeight() - VERT_OFFSET), this.GetWidth(), VERT_OFFSET);
        }
        if (dir == DatConstants.NPC_DIR_FRONT) {
            return new MmgRect(new MmgVector2(this.GetX(), this.GetY() + this.GetHeight() - VERT_OFFSET + this.SPEED), this.GetWidth(), VERT_OFFSET);
        }
        if (dir == DatConstants.NPC_DIR_BACK) {
            return new MmgRect(new MmgVector2(this.GetX(), this.GetY() + this.GetHeight() - VERT_OFFSET - this.SPEED), this.GetWidth(), VERT_OFFSET);
        }
        return this.GetPseudoDepthCollisionRect();
    }

    public final MmgRect GetProjectedWalkCollisionRect(int dir) {
        if (dir == DatConstants.NPC_DIR_RIGHT) {
            return new MmgRect(new MmgVector2(this.GetX() + this.SPEED, this.GetY()), this.GetWidth(), this.GetHeight());
        }
        if (dir == DatConstants.NPC_DIR_LEFT) {
            return new MmgRect(new MmgVector2(this.GetX() - this.SPEED, this.GetY()), this.GetWidth(), this.GetHeight());
        }
        if (dir == DatConstants.NPC_DIR_FRONT) {
            return new MmgRect(new MmgVector2(this.GetX(), this.GetY() + this.SPEED), this.GetWidth(), this.GetHeight());
        }
        if (dir == DatConstants.NPC_DIR_BACK) {
            return new MmgRect(new MmgVector2(this.GetX(), this.GetY() - this.SPEED), this.GetWidth(), this.GetHeight());
        }
        return this.GetCollisionRect();
    }

    public final MmgRect GetWalkCollisionRect() {
        if (this.currentState == DatConstants.NPC_STATE_WALKING) {
            if (this.currentDir == DatConstants.NPC_DIR_RIGHT) {
                return new MmgRect(new MmgVector2(this.GetX() + this.SPEED, this.GetY()), this.GetWidth(), this.GetHeight());
            }
            if (this.currentDir == DatConstants.NPC_DIR_LEFT) {
                return new MmgRect(new MmgVector2(this.GetX() - this.SPEED, this.GetY()), this.GetWidth(), this.GetHeight());
            }
            if (this.currentDir == DatConstants.NPC_DIR_FRONT) {
                return new MmgRect(new MmgVector2(this.GetX(), this.GetY() + this.SPEED), this.GetWidth(), this.GetHeight());
            }
            if (this.currentDir == DatConstants.NPC_DIR_BACK) {
                return new MmgRect(new MmgVector2(this.GetX(), this.GetY() - this.SPEED), this.GetWidth(), this.GetHeight());
            }
            return this.GetCollisionRect();
        }
        return this.GetCollisionRect();
    }

    public final int GetPseudoDepthWalkCollisionY() {
        if (this.currentState == DatConstants.NPC_STATE_WALKING) {
            if (this.currentDir == DatConstants.NPC_DIR_RIGHT) {
                return this.GetY() + this.GetHeight() - VERT_OFFSET;
            }
            if (this.currentDir == DatConstants.NPC_DIR_LEFT) {
                return this.GetY() + this.GetHeight() - VERT_OFFSET;
            }
            if (this.currentDir == DatConstants.NPC_DIR_FRONT) {
                return this.GetY() + this.GetHeight() - VERT_OFFSET + this.SPEED;
            }
            if (this.currentDir == DatConstants.NPC_DIR_BACK) {
                return this.GetY() + this.GetHeight() - VERT_OFFSET - this.SPEED;
            }
            return this.GetPseudoDepthCollisionY();
        }
        return this.GetPseudoDepthCollisionY();
    }

    public final void LoadResources() {
        this.pause = true;
        int len = this.pcImgIds.length;
        MmgBmp[] frames = new MmgBmp[len];
        for (int i = 0; i < len; ++i) {
            if (DatConstants.IsBadIndex(this.pcImgIdxs[i])) {
                TyreDatGameUtils.wr("PC Missing frame: " + i);
                continue;
            }
            frames[i] = TyreDatGameUtils.GetDatCachedBmp(this.pcImgIdxs[i], this.pcImgIds[i]);
        }
        this.pc = new MmgSprite(frames);
        this.pc.SetSimpleRendering(true);
        if (this.pcRenderMode == TyreNpc.NpcRenderMode.PREVIEW) {
            this.pc.SetOnFrameChange(null);
            this.pc.SetTimerOnly(false);
        } else {
            this.pc.SetOnFrameChange((MmgEventHandler)this);
            this.pc.SetTimerOnly(true);
        }
        this.pc.SetPosition(this.GetPosition());
        this.pc.SetMsPerFrame((long)DEFAULT_MS_PER_FRAME_PACING);
        if (DatConstants.NPC_DIR_FRONT == this.GetStartingDir()) {
            this.FaceFront();
        } else if (DatConstants.NPC_DIR_LEFT == this.GetStartingDir()) {
            this.FaceLeft();
        } else if (DatConstants.NPC_DIR_RIGHT == this.GetStartingDir()) {
            this.FaceRight();
        } else if (DatConstants.NPC_DIR_BACK == this.GetStartingDir()) {
            this.FaceBack();
        }
        this.ready = true;
        this.pause = false;
    }

    public final void UnloadResources() {
        this.pause = true;
        this.pc = null;
        this.pcImgIds = null;
        this.pcImgIdxs = null;
        this.ready = false;
    }

    public final void SetPosition(MmgVector2 pos) {
        super.SetPosition(pos);
        this.pc.SetPosition(pos);
    }

    public final MmgVector2 GetPosition() {
        return super.GetPosition();
    }

    public final TyrePc Clone() {
        TyrePc ret = new TyrePc(this.datObj, this.GetPcRenderMode());
        ret.SetCurrentDir(this.GetCurrentDir());
        ret.SetCurrentFoot(this.GetCurrentFoot());
        ret.SetCurrentState(this.GetCurrentState());
        ret.SetMsPerFrame(this.GetMsPerFrame());
        ret.SetPosition(this.GetPosition());
        ret.GetPc().SetFrameIdx(this.pc.GetFrameIdx());
        ret.GetPc().SetFrameStart(this.pc.GetFrameStart());
        ret.GetPc().SetFrameStop(this.pc.GetFrameStop());
        ret.SetWidth(this.GetWidth());
        ret.SetHeight(this.GetHeight());
        ret.SetRoomViewIndex(this.GetRoomViewIndex());
        ret.SetReachedRoomCenter(this.HasReachedRoomCenter());
        return ret;
    }

    public final void MmgDraw(MmgPen p) {
        if (!this.pause && this.isVisible) {
            this.pc.MmgDraw(p);
        }
    }

    public final boolean MmgUpdate(int updateTick, long currentTimeMs, long msSinceLastFrame) {
        this.lret = false;
        if (this.isVisible && this.GetPcRenderMode() != TyreNpc.NpcRenderMode.PREVIEW) {
            if (this.pc.MmgUpdate(updateTick, currentTimeMs, msSinceLastFrame)) {
                this.lret = true;
            }
            if (this.currentState == DatConstants.NPC_STATE_WALKING) {
                this.pcRoomView = GamePanel.SCREEN_MAIN_GAME.GetOverworldView().GetPcRoomView();
                this.pcRect = this.GetPseudoDepthWalkCollisionRect();
                this.diffLocal = this.pcRoomView != null ? this.pcRoomView.CollidesWithForPc(this.pcRect) : new CollisionResult();
                this.diffOverworld = this.diffLocal.CanWalk() ? GamePanel.SCREEN_MAIN_GAME.GetOverworldView().ScrollViewPort(this.GetWalkCollisionRect()) : new CollisionResult();
                if (LIMIT_MOVEMENT_AT_ROOM_EDGES) {
                    if (this.diffOverworld.CanWalk()) {
                        if (this.diffLocal.CanWalk()) {
                            TyreOverworldViewActionSearch.SEARCH_COUNT_RECENT = 0;
                            TyreOverworldViewActionInvestigate.INVESTIGATE_COUNT_RECENT = 0;
                            ++this.GetState().stepCount;
                            if (this.pcRoomView.HasBattle() && !this.pcRoomView.CollidesWithForLink(this.pcRect).CanWalk()) {
                                TyreDatGameUtils.wr("Battle connection found.");
                            }
                            if (this.pcRoomView.HasLink() && !this.pcRoomView.CollidesWithForLink(this.pcRect).CanWalk()) {
                                TyreDatGameUtils.wr("Link connection found.");
                            }
                            if (this.currentDir == DatConstants.NPC_DIR_LEFT && this.GetPseudoDepthCollisionY() < ScreenMainGame.SCALED_ROOM_HEIGHT && this.GetPseudoDepthCollisionY() > 0) {
                                this.SetX(this.GetX() - this.SPEED);
                                this.lret = true;
                            } else if (this.currentDir == DatConstants.NPC_DIR_RIGHT && this.GetPseudoDepthCollisionY() < ScreenMainGame.SCALED_ROOM_HEIGHT && this.GetPseudoDepthCollisionY() > 0) {
                                this.SetX(this.GetX() + this.SPEED);
                                this.lret = true;
                            } else if (this.currentDir == DatConstants.NPC_DIR_FRONT && this.GetPosition().GetX() < ScreenMainGame.SCALED_ROOM_WIDTH && this.GetPosition().GetX() > 0) {
                                this.SetY(this.GetY() + this.SPEED);
                                this.lret = true;
                            } else if (this.currentDir == DatConstants.NPC_DIR_BACK && this.GetPosition().GetX() < ScreenMainGame.SCALED_ROOM_WIDTH && this.GetPosition().GetX() > 0) {
                                this.SetY(this.GetY() - this.SPEED);
                                this.lret = true;
                            }
                        } else if (!this.diffLocal.IsIgnore()) {
                            if (this.currentDir == DatConstants.NPC_DIR_LEFT && this.GetPseudoDepthCollisionY() < ScreenMainGame.SCALED_ROOM_HEIGHT && this.GetPseudoDepthCollisionY() > 0) {
                                if (this.diffLocal.GetOffset().GetX() >= -this.SPEED && this.diffLocal.GetOffset().GetX() <= this.SPEED) {
                                    this.SetX(this.GetX() - (this.SPEED + this.diffLocal.GetOffset().GetX()) + 2);
                                    this.lret = true;
                                }
                            } else if (this.currentDir == DatConstants.NPC_DIR_RIGHT && this.GetPseudoDepthCollisionY() < ScreenMainGame.SCALED_ROOM_HEIGHT && this.GetPseudoDepthCollisionY() > 0) {
                                if (this.diffLocal.GetOffset().GetX() >= -this.SPEED && this.diffLocal.GetOffset().GetX() <= this.SPEED) {
                                    this.SetX(this.GetX() + (this.SPEED - this.diffLocal.GetOffset().GetX()) - 2);
                                    this.lret = true;
                                }
                            } else if (this.currentDir == DatConstants.NPC_DIR_FRONT && this.GetPosition().GetX() < ScreenMainGame.SCALED_ROOM_WIDTH && this.GetPosition().GetX() > 0) {
                                if (this.diffLocal.GetOffset().GetY() >= -this.SPEED && this.diffLocal.GetOffset().GetY() <= this.SPEED) {
                                    this.SetY(this.GetY() + (this.SPEED - this.diffLocal.GetOffset().GetY()) - 2);
                                    this.lret = true;
                                }
                            } else if (this.currentDir == DatConstants.NPC_DIR_BACK && this.GetPosition().GetX() < ScreenMainGame.SCALED_ROOM_WIDTH && this.GetPosition().GetX() > 0 && this.diffLocal.GetOffset().GetY() >= -this.SPEED && this.diffLocal.GetOffset().GetY() <= this.SPEED) {
                                this.SetY(this.GetY() - (this.SPEED + this.diffLocal.GetOffset().GetY()) + 2);
                                this.lret = true;
                            }
                        }
                    } else if (this.diffLocal.CanWalk()) {
                        TyreOverworldViewActionSearch.SEARCH_COUNT_RECENT = 0;
                        TyreOverworldViewActionInvestigate.INVESTIGATE_COUNT_RECENT = 0;
                        ++this.GetState().stepCount;
                        if (this.pcRoomView.HasBattle() && !this.pcRoomView.CollidesWithForLink(this.pcRect).CanWalk()) {
                            TyreDatGameUtils.wr("Battle connection found.");
                        }
                        if (this.pcRoomView.HasLink() && !this.pcRoomView.CollidesWithForLink(this.pcRect).CanWalk()) {
                            TyreDatGameUtils.wr("Link connection found.");
                        }
                        if (this.currentDir == DatConstants.NPC_DIR_LEFT && this.GetX() - this.SPEED >= 0 && this.GetPseudoDepthCollisionY() < ScreenMainGame.SCALED_ROOM_HEIGHT && this.GetPseudoDepthCollisionY() > 0) {
                            this.SetX(this.GetX() - this.SPEED);
                            this.lret = true;
                        } else if (this.currentDir == DatConstants.NPC_DIR_RIGHT && this.GetX() + this.GetWidth() + this.SPEED <= ScreenMainGame.SCALED_ROOM_WIDTH && this.GetPseudoDepthCollisionY() < ScreenMainGame.SCALED_ROOM_HEIGHT && this.GetPseudoDepthCollisionY() > 0) {
                            this.SetX(this.GetX() + this.SPEED);
                            this.lret = true;
                        } else if (this.currentDir == DatConstants.NPC_DIR_FRONT && this.GetY() + this.GetHeight() + this.SPEED <= ScreenMainGame.SCALED_ROOM_HEIGHT && this.GetPosition().GetX() < ScreenMainGame.SCALED_ROOM_WIDTH && this.GetPosition().GetX() > 0) {
                            this.SetY(this.GetY() + this.SPEED);
                            this.lret = true;
                        } else if (this.currentDir == DatConstants.NPC_DIR_BACK && this.GetY() - this.SPEED >= 0 && this.GetPosition().GetX() < ScreenMainGame.SCALED_ROOM_WIDTH && this.GetPosition().GetX() > 0) {
                            this.SetY(this.GetY() - this.SPEED);
                            this.lret = true;
                        }
                    } else if (!this.diffLocal.IsIgnore()) {
                        if (this.currentDir == DatConstants.NPC_DIR_LEFT && this.GetX() - this.SPEED >= 0 && this.GetPseudoDepthCollisionY() < ScreenMainGame.SCALED_ROOM_HEIGHT && this.GetPseudoDepthCollisionY() > 0) {
                            if (this.diffLocal.GetOffset().GetX() >= -this.SPEED && this.diffLocal.GetOffset().GetX() <= this.SPEED) {
                                this.SetX(this.GetX() - (this.SPEED + this.diffLocal.GetOffset().GetX()) + 2);
                                this.lret = true;
                            }
                        } else if (this.currentDir == DatConstants.NPC_DIR_RIGHT && this.GetX() + this.GetWidth() + this.SPEED <= ScreenMainGame.SCALED_ROOM_WIDTH && this.GetPseudoDepthCollisionY() < ScreenMainGame.SCALED_ROOM_HEIGHT && this.GetPseudoDepthCollisionY() > 0) {
                            if (this.diffLocal.GetOffset().GetX() >= -this.SPEED && this.diffLocal.GetOffset().GetX() <= this.SPEED) {
                                this.SetX(this.GetX() + (this.SPEED - this.diffLocal.GetOffset().GetX()) - 2);
                                this.lret = true;
                            }
                        } else if (this.currentDir == DatConstants.NPC_DIR_FRONT && this.GetY() + this.GetHeight() + this.SPEED <= ScreenMainGame.SCALED_ROOM_HEIGHT && this.GetPosition().GetX() < ScreenMainGame.SCALED_ROOM_WIDTH && this.GetPosition().GetX() > 0) {
                            if (this.diffLocal.GetOffset().GetY() >= -this.SPEED && this.diffLocal.GetOffset().GetY() <= this.SPEED) {
                                this.SetY(this.GetY() + (this.SPEED - this.diffLocal.GetOffset().GetY()) - 2);
                                this.lret = true;
                            }
                        } else if (this.currentDir == DatConstants.NPC_DIR_BACK && this.GetY() - this.SPEED >= 0 && this.GetPosition().GetX() < ScreenMainGame.SCALED_ROOM_WIDTH && this.GetPosition().GetX() > 0 && this.diffLocal.GetOffset().GetY() >= -this.SPEED && this.diffLocal.GetOffset().GetY() <= this.SPEED) {
                            this.SetY(this.GetY() - (this.SPEED + this.diffLocal.GetOffset().GetY()) + 2);
                            this.lret = true;
                        }
                    }
                } else if (this.diffOverworld.CanWalk()) {
                    if (this.diffLocal.CanWalk()) {
                        TyreOverworldViewActionSearch.SEARCH_COUNT_RECENT = 0;
                        TyreOverworldViewActionInvestigate.INVESTIGATE_COUNT_RECENT = 0;
                        ++this.GetState().stepCount;
                        if (this.pcRoomView.HasBattle() || this.pcRoomView.HasLink()) {
                            // empty if block
                        }
                        if (this.currentDir == DatConstants.NPC_DIR_LEFT) {
                            this.SetX(this.GetX() - this.SPEED);
                            this.lret = true;
                        } else if (this.currentDir == DatConstants.NPC_DIR_RIGHT) {
                            this.SetX(this.GetX() + this.SPEED);
                            this.lret = true;
                        } else if (this.currentDir == DatConstants.NPC_DIR_FRONT) {
                            this.SetY(this.GetY() + this.SPEED);
                            this.lret = true;
                        } else if (this.currentDir == DatConstants.NPC_DIR_BACK) {
                            this.SetY(this.GetY() - this.SPEED);
                            this.lret = true;
                        }
                    } else {
                        TyreDatGameUtils.wr("Cant walk....Granular adjustment...");
                        if (!this.diffLocal.IsIgnore()) {
                            if (this.currentDir == DatConstants.NPC_DIR_LEFT) {
                                if (this.diffLocal.GetOffset().GetX() >= -this.SPEED && this.diffLocal.GetOffset().GetX() <= this.SPEED) {
                                    this.SetX(this.GetX() - (this.SPEED + this.diffLocal.GetOffset().GetX()) + 2);
                                    this.lret = true;
                                }
                            } else if (this.currentDir == DatConstants.NPC_DIR_RIGHT) {
                                if (this.diffLocal.GetOffset().GetX() >= -this.SPEED && this.diffLocal.GetOffset().GetX() <= this.SPEED) {
                                    this.SetX(this.GetX() + (this.SPEED - this.diffLocal.GetOffset().GetX()) - 2);
                                    this.lret = true;
                                }
                            } else if (this.currentDir == DatConstants.NPC_DIR_FRONT) {
                                if (this.diffLocal.GetOffset().GetY() >= -this.SPEED && this.diffLocal.GetOffset().GetY() <= this.SPEED) {
                                    this.SetY(this.GetY() + (this.SPEED - this.diffLocal.GetOffset().GetY()) - 2);
                                    this.lret = true;
                                }
                            } else if (this.currentDir == DatConstants.NPC_DIR_BACK && this.diffLocal.GetOffset().GetY() >= -this.SPEED && this.diffLocal.GetOffset().GetY() <= this.SPEED) {
                                this.SetY(this.GetY() - (this.SPEED + this.diffLocal.GetOffset().GetY()) + 2);
                                this.lret = true;
                            }
                        }
                    }
                } else if (this.diffLocal.CanWalk()) {
                    TyreOverworldViewActionSearch.SEARCH_COUNT_RECENT = 0;
                    TyreOverworldViewActionInvestigate.INVESTIGATE_COUNT_RECENT = 0;
                    ++this.GetState().stepCount;
                    if (this.pcRoomView.HasBattle() || this.pcRoomView.HasLink()) {
                        // empty if block
                    }
                    if (this.currentDir == DatConstants.NPC_DIR_LEFT && this.GetX() - this.SPEED >= 0) {
                        this.SetX(this.GetX() - this.SPEED);
                        this.lret = true;
                    } else if (this.currentDir == DatConstants.NPC_DIR_RIGHT && this.GetX() + this.GetWidth() + this.SPEED <= ScreenMainGame.SCALED_ROOM_WIDTH) {
                        this.SetX(this.GetX() + this.SPEED);
                        this.lret = true;
                    } else if (this.currentDir == DatConstants.NPC_DIR_FRONT && this.GetY() + this.GetHeight() + this.SPEED <= ScreenMainGame.SCALED_ROOM_HEIGHT) {
                        this.SetY(this.GetY() + this.SPEED);
                        this.lret = true;
                    } else if (this.currentDir == DatConstants.NPC_DIR_BACK && this.GetY() - this.SPEED >= 0) {
                        this.SetY(this.GetY() - this.SPEED);
                        this.lret = true;
                    }
                } else if (!this.diffLocal.IsIgnore()) {
                    if (this.currentDir == DatConstants.NPC_DIR_LEFT && this.GetX() - this.SPEED >= 0) {
                        if (this.diffLocal.GetOffset().GetX() >= -this.SPEED && this.diffLocal.GetOffset().GetX() <= this.SPEED) {
                            this.SetX(this.GetX() - (this.SPEED + this.diffLocal.GetOffset().GetX()) + 2);
                            this.lret = true;
                        }
                    } else if (this.currentDir == DatConstants.NPC_DIR_RIGHT && this.GetX() + this.GetWidth() + this.SPEED <= ScreenMainGame.SCALED_ROOM_WIDTH) {
                        if (this.diffLocal.GetOffset().GetX() >= -this.SPEED && this.diffLocal.GetOffset().GetX() <= this.SPEED) {
                            this.SetX(this.GetX() + (this.SPEED - this.diffLocal.GetOffset().GetX()) - 2);
                            this.lret = true;
                        }
                    } else if (this.currentDir == DatConstants.NPC_DIR_FRONT && this.GetY() + this.GetHeight() + this.SPEED <= ScreenMainGame.SCALED_ROOM_HEIGHT) {
                        if (this.diffLocal.GetOffset().GetY() >= -this.SPEED && this.diffLocal.GetOffset().GetY() <= this.SPEED) {
                            this.SetY(this.GetY() + (this.SPEED - this.diffLocal.GetOffset().GetY()) - 2);
                            this.lret = true;
                        }
                    } else if (this.currentDir == DatConstants.NPC_DIR_BACK && this.GetY() - this.SPEED >= 0 && this.diffLocal.GetOffset().GetY() >= -this.SPEED && this.diffLocal.GetOffset().GetY() <= this.SPEED) {
                        this.SetY(this.GetY() - (this.SPEED + this.diffLocal.GetOffset().GetY()) + 2);
                        this.lret = true;
                    }
                }
            }
        }
        return this.lret;
    }

    public final int GetWidth() {
        return this.pc.GetWidth();
    }

    public final void SetWidth(int i) {
        this.pc.SetWidth(i);
    }

    public final int GetHeight() {
        return this.pc.GetHeight();
    }

    public final void SetHeight(int i) {
        this.pc.SetHeight(i);
    }
}

